/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * UpdateMaintenanceWindowTaskRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateMaintenanceWindowTaskRequestModelMarshaller {

    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").build();
    private static final MarshallingInfo<String> WINDOWTASKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTaskId").build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").build();
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskArn").build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").build();
    private static final MarshallingInfo<Map> TASKPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskParameters").build();
    private static final MarshallingInfo<StructuredPojo> TASKINVOCATIONPARAMETERS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("TaskInvocationParameters").build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").build();
    private static final MarshallingInfo<StructuredPojo> LOGGINGINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoggingInfo")
            .build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Boolean> REPLACE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Replace").build();

    private static final UpdateMaintenanceWindowTaskRequestModelMarshaller INSTANCE = new UpdateMaintenanceWindowTaskRequestModelMarshaller();

    public static UpdateMaintenanceWindowTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateMaintenanceWindowTaskRequest updateMaintenanceWindowTaskRequest,
            ProtocolMarshaller protocolMarshaller) {

        if (updateMaintenanceWindowTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.windowId(), WINDOWID_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.windowTaskId(), WINDOWTASKID_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.targets(), TARGETS_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.taskArn(), TASKARN_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.taskParameters(), TASKPARAMETERS_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.taskInvocationParameters(),
                    TASKINVOCATIONPARAMETERS_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.priority(), PRIORITY_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.maxConcurrency(), MAXCONCURRENCY_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.maxErrors(), MAXERRORS_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.loggingInfo(), LOGGINGINFO_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.name(), NAME_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.description(), DESCRIPTION_BINDING);

            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.replace(), REPLACE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
