/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InstancePatchState JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstancePatchStateUnmarshaller implements Unmarshaller<InstancePatchState, JsonUnmarshallerContext> {

    public InstancePatchState unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstancePatchState.Builder instancePatchStateBuilder = InstancePatchState.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.instanceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PatchGroup", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.patchGroup(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BaselineId", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.baselineId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SnapshotId", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.snapshotId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OwnerInformation", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.ownerInformation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstalledCount", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.installedCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("InstalledOtherCount", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.installedOtherCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("MissingCount", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.missingCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("FailedCount", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.failedCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("NotApplicableCount", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.notApplicableCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("OperationStartTime", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.operationStartTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("OperationEndTime", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.operationEndTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("Operation", targetDepth)) {
                    context.nextToken();
                    instancePatchStateBuilder.operation(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return instancePatchStateBuilder.build();
    }

    private static final InstancePatchStateUnmarshaller INSTANCE = new InstancePatchStateUnmarshaller();

    public static InstancePatchStateUnmarshaller getInstance() {
        return INSTANCE;
    }
}
