/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * InstanceInformationMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class InstanceInformationMarshaller {

    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> PINGSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PingStatus").build();
    private static final MarshallingInfo<java.time.Instant> LASTPINGDATETIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastPingDateTime")
            .build();
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").build();
    private static final MarshallingInfo<Boolean> ISLATESTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsLatestVersion").build();
    private static final MarshallingInfo<String> PLATFORMTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformType").build();
    private static final MarshallingInfo<String> PLATFORMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformName").build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformVersion").build();
    private static final MarshallingInfo<String> ACTIVATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivationId").build();
    private static final MarshallingInfo<String> IAMROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").build();
    private static final MarshallingInfo<java.time.Instant> REGISTRATIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationDate")
            .build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IPAddress").build();
    private static final MarshallingInfo<String> COMPUTERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputerName").build();
    private static final MarshallingInfo<String> ASSOCIATIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationStatus").build();
    private static final MarshallingInfo<java.time.Instant> LASTASSOCIATIONEXECUTIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastAssociationExecutionDate").build();
    private static final MarshallingInfo<java.time.Instant> LASTSUCCESSFULASSOCIATIONEXECUTIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulAssociationExecutionDate").build();
    private static final MarshallingInfo<StructuredPojo> ASSOCIATIONOVERVIEW_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AssociationOverview").build();

    private static final InstanceInformationMarshaller INSTANCE = new InstanceInformationMarshaller();

    public static InstanceInformationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(InstanceInformation instanceInformation, ProtocolMarshaller protocolMarshaller) {

        if (instanceInformation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(instanceInformation.instanceId(), INSTANCEID_BINDING);

            protocolMarshaller.marshall(instanceInformation.pingStatusString(), PINGSTATUS_BINDING);

            protocolMarshaller.marshall(instanceInformation.lastPingDateTime(), LASTPINGDATETIME_BINDING);

            protocolMarshaller.marshall(instanceInformation.agentVersion(), AGENTVERSION_BINDING);

            protocolMarshaller.marshall(instanceInformation.isLatestVersion(), ISLATESTVERSION_BINDING);

            protocolMarshaller.marshall(instanceInformation.platformTypeString(), PLATFORMTYPE_BINDING);

            protocolMarshaller.marshall(instanceInformation.platformName(), PLATFORMNAME_BINDING);

            protocolMarshaller.marshall(instanceInformation.platformVersion(), PLATFORMVERSION_BINDING);

            protocolMarshaller.marshall(instanceInformation.activationId(), ACTIVATIONID_BINDING);

            protocolMarshaller.marshall(instanceInformation.iamRole(), IAMROLE_BINDING);

            protocolMarshaller.marshall(instanceInformation.registrationDate(), REGISTRATIONDATE_BINDING);

            protocolMarshaller.marshall(instanceInformation.resourceTypeString(), RESOURCETYPE_BINDING);

            protocolMarshaller.marshall(instanceInformation.name(), NAME_BINDING);

            protocolMarshaller.marshall(instanceInformation.ipAddress(), IPADDRESS_BINDING);

            protocolMarshaller.marshall(instanceInformation.computerName(), COMPUTERNAME_BINDING);

            protocolMarshaller.marshall(instanceInformation.associationStatus(), ASSOCIATIONSTATUS_BINDING);

            protocolMarshaller.marshall(instanceInformation.lastAssociationExecutionDate(), LASTASSOCIATIONEXECUTIONDATE_BINDING);

            protocolMarshaller.marshall(instanceInformation.lastSuccessfulAssociationExecutionDate(),
                    LASTSUCCESSFULASSOCIATIONEXECUTIONDATE_BINDING);

            protocolMarshaller.marshall(instanceInformation.associationOverview(), ASSOCIATIONOVERVIEW_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
