/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * AutomationExecutionMetadataMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class AutomationExecutionMetadataMarshaller {

    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionId").build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONSTATUS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AutomationExecutionStatus").build();
    private static final MarshallingInfo<java.time.Instant> EXECUTIONSTARTTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExecutionStartTime").build();
    private static final MarshallingInfo<java.time.Instant> EXECUTIONENDTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEndTime")
            .build();
    private static final MarshallingInfo<String> EXECUTEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutedBy").build();
    private static final MarshallingInfo<String> LOGFILE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogFile").build();
    private static final MarshallingInfo<Map> OUTPUTS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").build();

    private static final AutomationExecutionMetadataMarshaller INSTANCE = new AutomationExecutionMetadataMarshaller();

    public static AutomationExecutionMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AutomationExecutionMetadata automationExecutionMetadata, ProtocolMarshaller protocolMarshaller) {

        if (automationExecutionMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(automationExecutionMetadata.automationExecutionId(), AUTOMATIONEXECUTIONID_BINDING);

            protocolMarshaller.marshall(automationExecutionMetadata.documentName(), DOCUMENTNAME_BINDING);

            protocolMarshaller.marshall(automationExecutionMetadata.documentVersion(), DOCUMENTVERSION_BINDING);

            protocolMarshaller.marshall(automationExecutionMetadata.automationExecutionStatusString(),
                    AUTOMATIONEXECUTIONSTATUS_BINDING);

            protocolMarshaller.marshall(automationExecutionMetadata.executionStartTime(), EXECUTIONSTARTTIME_BINDING);

            protocolMarshaller.marshall(automationExecutionMetadata.executionEndTime(), EXECUTIONENDTIME_BINDING);

            protocolMarshaller.marshall(automationExecutionMetadata.executedBy(), EXECUTEDBY_BINDING);

            protocolMarshaller.marshall(automationExecutionMetadata.logFile(), LOGFILE_BINDING);

            protocolMarshaller.marshall(automationExecutionMetadata.outputs(), OUTPUTS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
