/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateAssociationResponse extends SSMResponse implements
        ToCopyableBuilder<UpdateAssociationResponse.Builder, UpdateAssociationResponse> {
    private final AssociationDescription associationDescription;

    private UpdateAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.associationDescription = builder.associationDescription;
    }

    /**
     * <p>
     * The description of the association that was updated.
     * </p>
     * 
     * @return The description of the association that was updated.
     */
    public AssociationDescription associationDescription() {
        return associationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssociationResponse)) {
            return false;
        }
        UpdateAssociationResponse other = (UpdateAssociationResponse) obj;
        return Objects.equals(associationDescription(), other.associationDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateAssociationResponse").add("AssociationDescription", associationDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationDescription":
            return Optional.of(clazz.cast(associationDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, UpdateAssociationResponse> {
        /**
         * <p>
         * The description of the association that was updated.
         * </p>
         * 
         * @param associationDescription
         *        The description of the association that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationDescription(AssociationDescription associationDescription);

        /**
         * <p>
         * The description of the association that was updated.
         * </p>
         * This is a convenience that creates an instance of the {@link AssociationDescription.Builder} avoiding the
         * need to create one manually via {@link AssociationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssociationDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #associationDescription(AssociationDescription)}.
         * 
         * @param associationDescription
         *        a consumer that will call methods on {@link AssociationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationDescription(AssociationDescription)
         */
        default Builder associationDescription(Consumer<AssociationDescription.Builder> associationDescription) {
            return associationDescription(AssociationDescription.builder().apply(associationDescription).build());
        }
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private AssociationDescription associationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssociationResponse model) {
            associationDescription(model.associationDescription);
        }

        public final AssociationDescription.Builder getAssociationDescription() {
            return associationDescription != null ? associationDescription.toBuilder() : null;
        }

        @Override
        public final Builder associationDescription(AssociationDescription associationDescription) {
            this.associationDescription = associationDescription;
            return this;
        }

        public final void setAssociationDescription(AssociationDescription.BuilderImpl associationDescription) {
            this.associationDescription = associationDescription != null ? associationDescription.build() : null;
        }

        @Override
        public UpdateAssociationResponse build() {
            return new UpdateAssociationResponse(this);
        }
    }
}
