/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SendAutomationSignalRequest extends SSMRequest implements
        ToCopyableBuilder<SendAutomationSignalRequest.Builder, SendAutomationSignalRequest> {
    private final String automationExecutionId;

    private final String signalType;

    private final Map<String, List<String>> payload;

    private SendAutomationSignalRequest(BuilderImpl builder) {
        super(builder);
        this.automationExecutionId = builder.automationExecutionId;
        this.signalType = builder.signalType;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The unique identifier for an existing Automation execution that you want to send the signal to.
     * </p>
     * 
     * @return The unique identifier for an existing Automation execution that you want to send the signal to.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    /**
     * <p>
     * The type of signal. Valid signal types include the following: Approve and Reject
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signalType} will
     * return {@link SignalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signalTypeString}.
     * </p>
     * 
     * @return The type of signal. Valid signal types include the following: Approve and Reject
     * @see SignalType
     */
    public SignalType signalType() {
        return SignalType.fromValue(signalType);
    }

    /**
     * <p>
     * The type of signal. Valid signal types include the following: Approve and Reject
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signalType} will
     * return {@link SignalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signalTypeString}.
     * </p>
     * 
     * @return The type of signal. Valid signal types include the following: Approve and Reject
     * @see SignalType
     */
    public String signalTypeString() {
        return signalType;
    }

    /**
     * <p>
     * The data sent with the signal. The data schema depends on the type of signal used in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data sent with the signal. The data schema depends on the type of signal used in the request.
     */
    public Map<String, List<String>> payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(signalTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAutomationSignalRequest)) {
            return false;
        }
        SendAutomationSignalRequest other = (SendAutomationSignalRequest) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId())
                && Objects.equals(signalTypeString(), other.signalTypeString()) && Objects.equals(payload(), other.payload());
    }

    @Override
    public String toString() {
        return ToString.builder("SendAutomationSignalRequest").add("AutomationExecutionId", automationExecutionId())
                .add("SignalType", signalTypeString()).add("Payload", payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.of(clazz.cast(automationExecutionId()));
        case "SignalType":
            return Optional.of(clazz.cast(signalTypeString()));
        case "Payload":
            return Optional.of(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, SendAutomationSignalRequest> {
        /**
         * <p>
         * The unique identifier for an existing Automation execution that you want to send the signal to.
         * </p>
         * 
         * @param automationExecutionId
         *        The unique identifier for an existing Automation execution that you want to send the signal to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);

        /**
         * <p>
         * The type of signal. Valid signal types include the following: Approve and Reject
         * </p>
         * 
         * @param signalType
         *        The type of signal. Valid signal types include the following: Approve and Reject
         * @see SignalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalType
         */
        Builder signalType(String signalType);

        /**
         * <p>
         * The type of signal. Valid signal types include the following: Approve and Reject
         * </p>
         * 
         * @param signalType
         *        The type of signal. Valid signal types include the following: Approve and Reject
         * @see SignalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalType
         */
        Builder signalType(SignalType signalType);

        /**
         * <p>
         * The data sent with the signal. The data schema depends on the type of signal used in the request.
         * </p>
         * 
         * @param payload
         *        The data sent with the signal. The data schema depends on the type of signal used in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Map<String, ? extends Collection<String>> payload);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String automationExecutionId;

        private String signalType;

        private Map<String, List<String>> payload;

        private BuilderImpl() {
        }

        private BuilderImpl(SendAutomationSignalRequest model) {
            automationExecutionId(model.automationExecutionId);
            signalType(model.signalType);
            payload(model.payload);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getSignalType() {
            return signalType;
        }

        @Override
        public final Builder signalType(String signalType) {
            this.signalType = signalType;
            return this;
        }

        @Override
        public final Builder signalType(SignalType signalType) {
            this.signalType(signalType.toString());
            return this;
        }

        public final void setSignalType(String signalType) {
            this.signalType = signalType;
        }

        public final Map<String, ? extends Collection<String>> getPayload() {
            return payload;
        }

        @Override
        public final Builder payload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
            return this;
        }

        public final void setPayload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendAutomationSignalRequest build() {
            return new SendAutomationSignalRequest(this);
        }
    }
}
