/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ssm.transform.NotificationConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations for sending notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NotificationConfig implements StructuredPojo, ToCopyableBuilder<NotificationConfig.Builder, NotificationConfig> {
    private final String notificationArn;

    private final List<String> notificationEvents;

    private final String notificationType;

    private NotificationConfig(BuilderImpl builder) {
        this.notificationArn = builder.notificationArn;
        this.notificationEvents = builder.notificationEvents;
        this.notificationType = builder.notificationType;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications
     * about command status changes to this topic.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes
     *         notifications about command status changes to this topic.
     */
    public String notificationArn() {
        return notificationArn;
    }

    /**
     * <p>
     * The different events for which you can receive notifications. These events include the following: All (events),
     * InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up Events and
     * Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The different events for which you can receive notifications. These events include the following: All
     *         (events), InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up
     *         Events and Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
     */
    public List<NotificationEvent> notificationEvents() {
        return TypeConverter.convert(notificationEvents, NotificationEvent::fromValue);
    }

    /**
     * <p>
     * The different events for which you can receive notifications. These events include the following: All (events),
     * InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up Events and
     * Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The different events for which you can receive notifications. These events include the following: All
     *         (events), InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up
     *         Events and Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
     */
    public List<String> notificationEventsStrings() {
        return notificationEvents;
    }

    /**
     * <p>
     * Command: Receive notification when the status of a command changes. Invocation: For commands sent to multiple
     * instances, receive notification on a per-instance basis when the status of a command changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeString}.
     * </p>
     * 
     * @return Command: Receive notification when the status of a command changes. Invocation: For commands sent to
     *         multiple instances, receive notification on a per-instance basis when the status of a command changes.
     * @see NotificationType
     */
    public NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * <p>
     * Command: Receive notification when the status of a command changes. Invocation: For commands sent to multiple
     * instances, receive notification on a per-instance basis when the status of a command changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeString}.
     * </p>
     * 
     * @return Command: Receive notification when the status of a command changes. Invocation: For commands sent to
     *         multiple instances, receive notification on a per-instance basis when the status of a command changes.
     * @see NotificationType
     */
    public String notificationTypeString() {
        return notificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEventsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig other = (NotificationConfig) obj;
        return Objects.equals(notificationArn(), other.notificationArn())
                && Objects.equals(notificationEventsStrings(), other.notificationEventsStrings())
                && Objects.equals(notificationTypeString(), other.notificationTypeString());
    }

    @Override
    public String toString() {
        return ToString.builder("NotificationConfig").add("NotificationArn", notificationArn())
                .add("NotificationEvents", notificationEventsStrings()).add("NotificationType", notificationTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationArn":
            return Optional.of(clazz.cast(notificationArn()));
        case "NotificationEvents":
            return Optional.of(clazz.cast(notificationEventsStrings()));
        case "NotificationType":
            return Optional.of(clazz.cast(notificationTypeString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NotificationConfig> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications
         * about command status changes to this topic.
         * </p>
         * 
         * @param notificationArn
         *        An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes
         *        notifications about command status changes to this topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArn(String notificationArn);

        /**
         * <p>
         * The different events for which you can receive notifications. These events include the following: All
         * (events), InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up Events
         * and Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
         * </p>
         * 
         * @param notificationEvents
         *        The different events for which you can receive notifications. These events include the following: All
         *        (events), InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up
         *        Events and Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEvents(Collection<String> notificationEvents);

        /**
         * <p>
         * The different events for which you can receive notifications. These events include the following: All
         * (events), InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up Events
         * and Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
         * </p>
         * 
         * @param notificationEvents
         *        The different events for which you can receive notifications. These events include the following: All
         *        (events), InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up
         *        Events and Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEvents(String... notificationEvents);

        /**
         * <p>
         * Command: Receive notification when the status of a command changes. Invocation: For commands sent to multiple
         * instances, receive notification on a per-instance basis when the status of a command changes.
         * </p>
         * 
         * @param notificationType
         *        Command: Receive notification when the status of a command changes. Invocation: For commands sent to
         *        multiple instances, receive notification on a per-instance basis when the status of a command changes.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * <p>
         * Command: Receive notification when the status of a command changes. Invocation: For commands sent to multiple
         * instances, receive notification on a per-instance basis when the status of a command changes.
         * </p>
         * 
         * @param notificationType
         *        Command: Receive notification when the status of a command changes. Invocation: For commands sent to
         *        multiple instances, receive notification on a per-instance basis when the status of a command changes.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);
    }

    static final class BuilderImpl implements Builder {
        private String notificationArn;

        private List<String> notificationEvents;

        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfig model) {
            notificationArn(model.notificationArn);
            notificationEvents(model.notificationEvents);
            notificationType(model.notificationType);
        }

        public final String getNotificationArn() {
            return notificationArn;
        }

        @Override
        public final Builder notificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
            return this;
        }

        public final void setNotificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
        }

        public final Collection<String> getNotificationEvents() {
            return notificationEvents;
        }

        @Override
        public final Builder notificationEvents(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEvents(String... notificationEvents) {
            notificationEvents(Arrays.asList(notificationEvents));
            return this;
        }

        public final void setNotificationEvents(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
        }

        public final String getNotificationType() {
            return notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public NotificationConfig build() {
            return new NotificationConfig(this);
        }
    }
}
