/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowStepFunctionsParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for the STEP_FUNCTION execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MaintenanceWindowStepFunctionsParameters implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowStepFunctionsParameters.Builder, MaintenanceWindowStepFunctionsParameters> {
    private final String input;

    private final String name;

    private MaintenanceWindowStepFunctionsParameters(BuilderImpl builder) {
        this.input = builder.input;
        this.name = builder.name;
    }

    /**
     * <p>
     * The inputs for the STEP_FUNCTION task.
     * </p>
     * 
     * @return The inputs for the STEP_FUNCTION task.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The name of the STEP_FUNCTION task.
     * </p>
     * 
     * @return The name of the STEP_FUNCTION task.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowStepFunctionsParameters)) {
            return false;
        }
        MaintenanceWindowStepFunctionsParameters other = (MaintenanceWindowStepFunctionsParameters) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(name(), other.name());
    }

    @Override
    public String toString() {
        return ToString.builder("MaintenanceWindowStepFunctionsParameters").add("Input", input()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Input":
            return Optional.of(clazz.cast(input()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowStepFunctionsParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowStepFunctionsParameters> {
        /**
         * <p>
         * The inputs for the STEP_FUNCTION task.
         * </p>
         * 
         * @param input
         *        The inputs for the STEP_FUNCTION task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The name of the STEP_FUNCTION task.
         * </p>
         * 
         * @param name
         *        The name of the STEP_FUNCTION task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String input;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowStepFunctionsParameters model) {
            input(model.input);
            name(model.name);
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public MaintenanceWindowStepFunctionsParameters build() {
            return new MaintenanceWindowStepFunctionsParameters(this);
        }
    }
}
