/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.LoggingInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon S3 bucket to write instance-level logs to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LoggingInfo implements StructuredPojo, ToCopyableBuilder<LoggingInfo.Builder, LoggingInfo> {
    private final String s3BucketName;

    private final String s3KeyPrefix;

    private final String s3Region;

    private LoggingInfo(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.s3Region = builder.s3Region;
    }

    /**
     * <p>
     * The name of an Amazon S3 bucket where execution logs are stored .
     * </p>
     * 
     * @return The name of an Amazon S3 bucket where execution logs are stored .
     */
    public String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * (Optional) The Amazon S3 bucket subfolder.
     * </p>
     * 
     * @return (Optional) The Amazon S3 bucket subfolder.
     */
    public String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * The region where the Amazon S3 bucket is located.
     * </p>
     * 
     * @return The region where the Amazon S3 bucket is located.
     */
    public String s3Region() {
        return s3Region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3Region());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingInfo)) {
            return false;
        }
        LoggingInfo other = (LoggingInfo) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix())
                && Objects.equals(s3Region(), other.s3Region());
    }

    @Override
    public String toString() {
        return ToString.builder("LoggingInfo").add("S3BucketName", s3BucketName()).add("S3KeyPrefix", s3KeyPrefix())
                .add("S3Region", s3Region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketName":
            return Optional.of(clazz.cast(s3BucketName()));
        case "S3KeyPrefix":
            return Optional.of(clazz.cast(s3KeyPrefix()));
        case "S3Region":
            return Optional.of(clazz.cast(s3Region()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LoggingInfo> {
        /**
         * <p>
         * The name of an Amazon S3 bucket where execution logs are stored .
         * </p>
         * 
         * @param s3BucketName
         *        The name of an Amazon S3 bucket where execution logs are stored .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * (Optional) The Amazon S3 bucket subfolder.
         * </p>
         * 
         * @param s3KeyPrefix
         *        (Optional) The Amazon S3 bucket subfolder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * The region where the Amazon S3 bucket is located.
         * </p>
         * 
         * @param s3Region
         *        The region where the Amazon S3 bucket is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Region(String s3Region);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketName;

        private String s3KeyPrefix;

        private String s3Region;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingInfo model) {
            s3BucketName(model.s3BucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            s3Region(model.s3Region);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getS3Region() {
            return s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        @Override
        public LoggingInfo build() {
            return new LoggingInfo(this);
        }
    }
}
