/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListAssociationVersionsResponse extends SSMResponse implements
        ToCopyableBuilder<ListAssociationVersionsResponse.Builder, ListAssociationVersionsResponse> {
    private final List<AssociationVersionInfo> associationVersions;

    private final String nextToken;

    private ListAssociationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.associationVersions = builder.associationVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about all versions of the association for the specified association ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about all versions of the association for the specified association ID.
     */
    public List<AssociationVersionInfo> associationVersions() {
        return associationVersions;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationVersions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationVersionsResponse)) {
            return false;
        }
        ListAssociationVersionsResponse other = (ListAssociationVersionsResponse) obj;
        return Objects.equals(associationVersions(), other.associationVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAssociationVersionsResponse").add("AssociationVersions", associationVersions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationVersions":
            return Optional.of(clazz.cast(associationVersions()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, ListAssociationVersionsResponse> {
        /**
         * <p>
         * Information about all versions of the association for the specified association ID.
         * </p>
         * 
         * @param associationVersions
         *        Information about all versions of the association for the specified association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersions(Collection<AssociationVersionInfo> associationVersions);

        /**
         * <p>
         * Information about all versions of the association for the specified association ID.
         * </p>
         * 
         * @param associationVersions
         *        Information about all versions of the association for the specified association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersions(AssociationVersionInfo... associationVersions);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<AssociationVersionInfo> associationVersions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationVersionsResponse model) {
            associationVersions(model.associationVersions);
            nextToken(model.nextToken);
        }

        public final Collection<AssociationVersionInfo.Builder> getAssociationVersions() {
            return associationVersions != null ? associationVersions.stream().map(AssociationVersionInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associationVersions(Collection<AssociationVersionInfo> associationVersions) {
            this.associationVersions = AssociationVersionListCopier.copy(associationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationVersions(AssociationVersionInfo... associationVersions) {
            associationVersions(Arrays.asList(associationVersions));
            return this;
        }

        public final void setAssociationVersions(Collection<AssociationVersionInfo.BuilderImpl> associationVersions) {
            this.associationVersions = AssociationVersionListCopier.copyFromBuilder(associationVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssociationVersionsResponse build() {
            return new ListAssociationVersionsResponse(this);
        }
    }
}
