/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetAutomationExecutionResponse extends SSMResponse implements
        ToCopyableBuilder<GetAutomationExecutionResponse.Builder, GetAutomationExecutionResponse> {
    private final AutomationExecution automationExecution;

    private GetAutomationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.automationExecution = builder.automationExecution;
    }

    /**
     * <p>
     * Detailed information about the current state of an automation execution.
     * </p>
     * 
     * @return Detailed information about the current state of an automation execution.
     */
    public AutomationExecution automationExecution() {
        return automationExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecution());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomationExecutionResponse)) {
            return false;
        }
        GetAutomationExecutionResponse other = (GetAutomationExecutionResponse) obj;
        return Objects.equals(automationExecution(), other.automationExecution());
    }

    @Override
    public String toString() {
        return ToString.builder("GetAutomationExecutionResponse").add("AutomationExecution", automationExecution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecution":
            return Optional.of(clazz.cast(automationExecution()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, GetAutomationExecutionResponse> {
        /**
         * <p>
         * Detailed information about the current state of an automation execution.
         * </p>
         * 
         * @param automationExecution
         *        Detailed information about the current state of an automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecution(AutomationExecution automationExecution);

        /**
         * <p>
         * Detailed information about the current state of an automation execution.
         * </p>
         * This is a convenience that creates an instance of the {@link AutomationExecution.Builder} avoiding the need
         * to create one manually via {@link AutomationExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutomationExecution.Builder#build()} is called immediately and
         * its result is passed to {@link #automationExecution(AutomationExecution)}.
         * 
         * @param automationExecution
         *        a consumer that will call methods on {@link AutomationExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automationExecution(AutomationExecution)
         */
        default Builder automationExecution(Consumer<AutomationExecution.Builder> automationExecution) {
            return automationExecution(AutomationExecution.builder().apply(automationExecution).build());
        }
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private AutomationExecution automationExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomationExecutionResponse model) {
            automationExecution(model.automationExecution);
        }

        public final AutomationExecution.Builder getAutomationExecution() {
            return automationExecution != null ? automationExecution.toBuilder() : null;
        }

        @Override
        public final Builder automationExecution(AutomationExecution automationExecution) {
            this.automationExecution = automationExecution;
            return this;
        }

        public final void setAutomationExecution(AutomationExecution.BuilderImpl automationExecution) {
            this.automationExecution = automationExecution != null ? automationExecution.build() : null;
        }

        @Override
        public GetAutomationExecutionResponse build() {
            return new GetAutomationExecutionResponse(this);
        }
    }
}
