/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePatchGroupsResponse extends SSMResponse implements
        ToCopyableBuilder<DescribePatchGroupsResponse.Builder, DescribePatchGroupsResponse> {
    private final List<PatchGroupPatchBaselineMapping> mappings;

    private final String nextToken;

    private DescribePatchGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.mappings = builder.mappings;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Each entry in the array contains:
     * </p>
     * <p>
     * PatchGroup: string (between 1 and 256 characters, Regex: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)
     * </p>
     * <p>
     * PatchBaselineIdentity: A PatchBaselineIdentity element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Each entry in the array contains:</p>
     *         <p>
     *         PatchGroup: string (between 1 and 256 characters, Regex: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)
     *         </p>
     *         <p>
     *         PatchBaselineIdentity: A PatchBaselineIdentity element.
     */
    public List<PatchGroupPatchBaselineMapping> mappings() {
        return mappings;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mappings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupsResponse)) {
            return false;
        }
        DescribePatchGroupsResponse other = (DescribePatchGroupsResponse) obj;
        return Objects.equals(mappings(), other.mappings()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePatchGroupsResponse").add("Mappings", mappings()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mappings":
            return Optional.of(clazz.cast(mappings()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DescribePatchGroupsResponse> {
        /**
         * <p>
         * Each entry in the array contains:
         * </p>
         * <p>
         * PatchGroup: string (between 1 and 256 characters, Regex: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)
         * </p>
         * <p>
         * PatchBaselineIdentity: A PatchBaselineIdentity element.
         * </p>
         * 
         * @param mappings
         *        Each entry in the array contains:</p>
         *        <p>
         *        PatchGroup: string (between 1 and 256 characters, Regex: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)
         *        </p>
         *        <p>
         *        PatchBaselineIdentity: A PatchBaselineIdentity element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappings(Collection<PatchGroupPatchBaselineMapping> mappings);

        /**
         * <p>
         * Each entry in the array contains:
         * </p>
         * <p>
         * PatchGroup: string (between 1 and 256 characters, Regex: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)
         * </p>
         * <p>
         * PatchBaselineIdentity: A PatchBaselineIdentity element.
         * </p>
         * 
         * @param mappings
         *        Each entry in the array contains:</p>
         *        <p>
         *        PatchGroup: string (between 1 and 256 characters, Regex: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)
         *        </p>
         *        <p>
         *        PatchBaselineIdentity: A PatchBaselineIdentity element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappings(PatchGroupPatchBaselineMapping... mappings);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<PatchGroupPatchBaselineMapping> mappings;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupsResponse model) {
            mappings(model.mappings);
            nextToken(model.nextToken);
        }

        public final Collection<PatchGroupPatchBaselineMapping.Builder> getMappings() {
            return mappings != null ? mappings.stream().map(PatchGroupPatchBaselineMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mappings(Collection<PatchGroupPatchBaselineMapping> mappings) {
            this.mappings = PatchGroupPatchBaselineMappingListCopier.copy(mappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappings(PatchGroupPatchBaselineMapping... mappings) {
            mappings(Arrays.asList(mappings));
            return this;
        }

        public final void setMappings(Collection<PatchGroupPatchBaselineMapping.BuilderImpl> mappings) {
            this.mappings = PatchGroupPatchBaselineMappingListCopier.copyFromBuilder(mappings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchGroupsResponse build() {
            return new DescribePatchGroupsResponse(this);
        }
    }
}
