/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePatchGroupStateResponse extends SSMResponse implements
        ToCopyableBuilder<DescribePatchGroupStateResponse.Builder, DescribePatchGroupStateResponse> {
    private final Integer instances;

    private final Integer instancesWithInstalledPatches;

    private final Integer instancesWithInstalledOtherPatches;

    private final Integer instancesWithMissingPatches;

    private final Integer instancesWithFailedPatches;

    private final Integer instancesWithNotApplicablePatches;

    private DescribePatchGroupStateResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.instancesWithInstalledPatches = builder.instancesWithInstalledPatches;
        this.instancesWithInstalledOtherPatches = builder.instancesWithInstalledOtherPatches;
        this.instancesWithMissingPatches = builder.instancesWithMissingPatches;
        this.instancesWithFailedPatches = builder.instancesWithFailedPatches;
        this.instancesWithNotApplicablePatches = builder.instancesWithNotApplicablePatches;
    }

    /**
     * <p>
     * The number of instances in the patch group.
     * </p>
     * 
     * @return The number of instances in the patch group.
     */
    public Integer instances() {
        return instances;
    }

    /**
     * <p>
     * The number of instances with installed patches.
     * </p>
     * 
     * @return The number of instances with installed patches.
     */
    public Integer instancesWithInstalledPatches() {
        return instancesWithInstalledPatches;
    }

    /**
     * <p>
     * The number of instances with patches installed that aren't defined in the patch baseline.
     * </p>
     * 
     * @return The number of instances with patches installed that aren't defined in the patch baseline.
     */
    public Integer instancesWithInstalledOtherPatches() {
        return instancesWithInstalledOtherPatches;
    }

    /**
     * <p>
     * The number of instances with missing patches from the patch baseline.
     * </p>
     * 
     * @return The number of instances with missing patches from the patch baseline.
     */
    public Integer instancesWithMissingPatches() {
        return instancesWithMissingPatches;
    }

    /**
     * <p>
     * The number of instances with patches from the patch baseline that failed to install.
     * </p>
     * 
     * @return The number of instances with patches from the patch baseline that failed to install.
     */
    public Integer instancesWithFailedPatches() {
        return instancesWithFailedPatches;
    }

    /**
     * <p>
     * The number of instances with patches that aren't applicable.
     * </p>
     * 
     * @return The number of instances with patches that aren't applicable.
     */
    public Integer instancesWithNotApplicablePatches() {
        return instancesWithNotApplicablePatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithInstalledPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithInstalledOtherPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithMissingPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithFailedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithNotApplicablePatches());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupStateResponse)) {
            return false;
        }
        DescribePatchGroupStateResponse other = (DescribePatchGroupStateResponse) obj;
        return Objects.equals(instances(), other.instances())
                && Objects.equals(instancesWithInstalledPatches(), other.instancesWithInstalledPatches())
                && Objects.equals(instancesWithInstalledOtherPatches(), other.instancesWithInstalledOtherPatches())
                && Objects.equals(instancesWithMissingPatches(), other.instancesWithMissingPatches())
                && Objects.equals(instancesWithFailedPatches(), other.instancesWithFailedPatches())
                && Objects.equals(instancesWithNotApplicablePatches(), other.instancesWithNotApplicablePatches());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePatchGroupStateResponse").add("Instances", instances())
                .add("InstancesWithInstalledPatches", instancesWithInstalledPatches())
                .add("InstancesWithInstalledOtherPatches", instancesWithInstalledOtherPatches())
                .add("InstancesWithMissingPatches", instancesWithMissingPatches())
                .add("InstancesWithFailedPatches", instancesWithFailedPatches())
                .add("InstancesWithNotApplicablePatches", instancesWithNotApplicablePatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.of(clazz.cast(instances()));
        case "InstancesWithInstalledPatches":
            return Optional.of(clazz.cast(instancesWithInstalledPatches()));
        case "InstancesWithInstalledOtherPatches":
            return Optional.of(clazz.cast(instancesWithInstalledOtherPatches()));
        case "InstancesWithMissingPatches":
            return Optional.of(clazz.cast(instancesWithMissingPatches()));
        case "InstancesWithFailedPatches":
            return Optional.of(clazz.cast(instancesWithFailedPatches()));
        case "InstancesWithNotApplicablePatches":
            return Optional.of(clazz.cast(instancesWithNotApplicablePatches()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DescribePatchGroupStateResponse> {
        /**
         * <p>
         * The number of instances in the patch group.
         * </p>
         * 
         * @param instances
         *        The number of instances in the patch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Integer instances);

        /**
         * <p>
         * The number of instances with installed patches.
         * </p>
         * 
         * @param instancesWithInstalledPatches
         *        The number of instances with installed patches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithInstalledPatches(Integer instancesWithInstalledPatches);

        /**
         * <p>
         * The number of instances with patches installed that aren't defined in the patch baseline.
         * </p>
         * 
         * @param instancesWithInstalledOtherPatches
         *        The number of instances with patches installed that aren't defined in the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches);

        /**
         * <p>
         * The number of instances with missing patches from the patch baseline.
         * </p>
         * 
         * @param instancesWithMissingPatches
         *        The number of instances with missing patches from the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithMissingPatches(Integer instancesWithMissingPatches);

        /**
         * <p>
         * The number of instances with patches from the patch baseline that failed to install.
         * </p>
         * 
         * @param instancesWithFailedPatches
         *        The number of instances with patches from the patch baseline that failed to install.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithFailedPatches(Integer instancesWithFailedPatches);

        /**
         * <p>
         * The number of instances with patches that aren't applicable.
         * </p>
         * 
         * @param instancesWithNotApplicablePatches
         *        The number of instances with patches that aren't applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private Integer instances;

        private Integer instancesWithInstalledPatches;

        private Integer instancesWithInstalledOtherPatches;

        private Integer instancesWithMissingPatches;

        private Integer instancesWithFailedPatches;

        private Integer instancesWithNotApplicablePatches;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupStateResponse model) {
            instances(model.instances);
            instancesWithInstalledPatches(model.instancesWithInstalledPatches);
            instancesWithInstalledOtherPatches(model.instancesWithInstalledOtherPatches);
            instancesWithMissingPatches(model.instancesWithMissingPatches);
            instancesWithFailedPatches(model.instancesWithFailedPatches);
            instancesWithNotApplicablePatches(model.instancesWithNotApplicablePatches);
        }

        public final Integer getInstances() {
            return instances;
        }

        @Override
        public final Builder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public final void setInstances(Integer instances) {
            this.instances = instances;
        }

        public final Integer getInstancesWithInstalledPatches() {
            return instancesWithInstalledPatches;
        }

        @Override
        public final Builder instancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
            return this;
        }

        public final void setInstancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
        }

        public final Integer getInstancesWithInstalledOtherPatches() {
            return instancesWithInstalledOtherPatches;
        }

        @Override
        public final Builder instancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
            return this;
        }

        public final void setInstancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
        }

        public final Integer getInstancesWithMissingPatches() {
            return instancesWithMissingPatches;
        }

        @Override
        public final Builder instancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
            return this;
        }

        public final void setInstancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
        }

        public final Integer getInstancesWithFailedPatches() {
            return instancesWithFailedPatches;
        }

        @Override
        public final Builder instancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
            return this;
        }

        public final void setInstancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
        }

        public final Integer getInstancesWithNotApplicablePatches() {
            return instancesWithNotApplicablePatches;
        }

        @Override
        public final Builder instancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
            return this;
        }

        public final void setInstancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
        }

        @Override
        public DescribePatchGroupStateResponse build() {
            return new DescribePatchGroupStateResponse(this);
        }
    }
}
