/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowExecutionTasksResponse extends SSMResponse
        implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionTasksResponse.Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
    private final List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTasksResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionTaskIdentities = builder.windowExecutionTaskIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the task executions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the task executions.
     */
    public List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities() {
        return windowExecutionTaskIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionTaskIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTasksResponse other = (DescribeMaintenanceWindowExecutionTasksResponse) obj;
        return Objects.equals(windowExecutionTaskIdentities(), other.windowExecutionTaskIdentities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMaintenanceWindowExecutionTasksResponse")
                .add("WindowExecutionTaskIdentities", windowExecutionTaskIdentities()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionTaskIdentities":
            return Optional.of(clazz.cast(windowExecutionTaskIdentities()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder,
            CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
        /**
         * <p>
         * Information about the task executions.
         * </p>
         * 
         * @param windowExecutionTaskIdentities
         *        Information about the task executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities);

        /**
         * <p>
         * Information about the task executions.
         * </p>
         * 
         * @param windowExecutionTaskIdentities
         *        Information about the task executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity... windowExecutionTaskIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTasksResponse model) {
            windowExecutionTaskIdentities(model.windowExecutionTaskIdentities);
            nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecutionTaskIdentity.Builder> getWindowExecutionTaskIdentities() {
            return windowExecutionTaskIdentities != null ? windowExecutionTaskIdentities.stream()
                    .map(MaintenanceWindowExecutionTaskIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowExecutionTaskIdentities(
                Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier
                    .copy(windowExecutionTaskIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskIdentities(
                MaintenanceWindowExecutionTaskIdentity... windowExecutionTaskIdentities) {
            windowExecutionTaskIdentities(Arrays.asList(windowExecutionTaskIdentities));
            return this;
        }

        public final void setWindowExecutionTaskIdentities(
                Collection<MaintenanceWindowExecutionTaskIdentity.BuilderImpl> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier
                    .copyFromBuilder(windowExecutionTaskIdentities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTasksResponse build() {
            return new DescribeMaintenanceWindowExecutionTasksResponse(this);
        }
    }
}
