/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancePatchStatesForPatchGroupRequest extends SSMRequest
        implements
        ToCopyableBuilder<DescribeInstancePatchStatesForPatchGroupRequest.Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
    private final String patchGroup;

    private final List<InstancePatchStateFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeInstancePatchStatesForPatchGroupRequest(BuilderImpl builder) {
        super(builder);
        this.patchGroup = builder.patchGroup;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the patch group for which the patch state information should be retrieved.
     * </p>
     * 
     * @return The name of the patch group for which the patch state information should be retrieved.
     */
    public String patchGroup() {
        return patchGroup;
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <p>
     * Key (string between 1 and 200 characters)
     * </p>
     * <p>
     * Values (array containing a single string)
     * </p>
     * <p>
     * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <p>
     *         Key (string between 1 and 200 characters)
     *         </p>
     *         <p>
     *         Values (array containing a single string)
     *         </p>
     *         <p>
     *         Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
     */
    public List<InstancePatchStateFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of patches to return (per page).
     * </p>
     * 
     * @return The maximum number of patches to return (per page).
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesForPatchGroupRequest)) {
            return false;
        }
        DescribeInstancePatchStatesForPatchGroupRequest other = (DescribeInstancePatchStatesForPatchGroupRequest) obj;
        return Objects.equals(patchGroup(), other.patchGroup()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeInstancePatchStatesForPatchGroupRequest").add("PatchGroup", patchGroup())
                .add("Filters", filters()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchGroup":
            return Optional.of(clazz.cast(patchGroup()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder,
            CopyableBuilder<Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
        /**
         * <p>
         * The name of the patch group for which the patch state information should be retrieved.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group for which the patch state information should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string between 1 and 200 characters)
         * </p>
         * <p>
         * Values (array containing a single string)
         * </p>
         * <p>
         * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string between 1 and 200 characters)
         *        </p>
         *        <p>
         *        Values (array containing a single string)
         *        </p>
         *        <p>
         *        Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InstancePatchStateFilter> filters);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string between 1 and 200 characters)
         * </p>
         * <p>
         * Values (array containing a single string)
         * </p>
         * <p>
         * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string between 1 and 200 characters)
         *        </p>
         *        <p>
         *        Values (array containing a single string)
         *        </p>
         *        <p>
         *        Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InstancePatchStateFilter... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of patches to return (per page).
         * </p>
         * 
         * @param maxResults
         *        The maximum number of patches to return (per page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String patchGroup;

        private List<InstancePatchStateFilter> filters;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesForPatchGroupRequest model) {
            patchGroup(model.patchGroup);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final Collection<InstancePatchStateFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(InstancePatchStateFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder filters(Collection<InstancePatchStateFilter> filters) {
            this.filters = InstancePatchStateFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InstancePatchStateFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<InstancePatchStateFilter.BuilderImpl> filters) {
            this.filters = InstancePatchStateFilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancePatchStatesForPatchGroupRequest build() {
            return new DescribeInstancePatchStatesForPatchGroupRequest(this);
        }
    }
}
