/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDocumentPermissionRequest extends SSMRequest implements
        ToCopyableBuilder<DescribeDocumentPermissionRequest.Builder, DescribeDocumentPermissionRequest> {
    private final String name;

    private final String permissionType;

    private DescribeDocumentPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.permissionType = builder.permissionType;
    }

    /**
     * <p>
     * The name of the document for which you are the owner.
     * </p>
     * 
     * @return The name of the document for which you are the owner.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The permission type for the document. The permission type can be <i>Share</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link DocumentPermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionTypeString}.
     * </p>
     * 
     * @return The permission type for the document. The permission type can be <i>Share</i>.
     * @see DocumentPermissionType
     */
    public DocumentPermissionType permissionType() {
        return DocumentPermissionType.fromValue(permissionType);
    }

    /**
     * <p>
     * The permission type for the document. The permission type can be <i>Share</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link DocumentPermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionTypeString}.
     * </p>
     * 
     * @return The permission type for the document. The permission type can be <i>Share</i>.
     * @see DocumentPermissionType
     */
    public String permissionTypeString() {
        return permissionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(permissionTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionRequest)) {
            return false;
        }
        DescribeDocumentPermissionRequest other = (DescribeDocumentPermissionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(permissionTypeString(), other.permissionTypeString());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDocumentPermissionRequest").add("Name", name())
                .add("PermissionType", permissionTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "PermissionType":
            return Optional.of(clazz.cast(permissionTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DescribeDocumentPermissionRequest> {
        /**
         * <p>
         * The name of the document for which you are the owner.
         * </p>
         * 
         * @param name
         *        The name of the document for which you are the owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The permission type for the document. The permission type can be <i>Share</i>.
         * </p>
         * 
         * @param permissionType
         *        The permission type for the document. The permission type can be <i>Share</i>.
         * @see DocumentPermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentPermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * <p>
         * The permission type for the document. The permission type can be <i>Share</i>.
         * </p>
         * 
         * @param permissionType
         *        The permission type for the document. The permission type can be <i>Share</i>.
         * @see DocumentPermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentPermissionType
         */
        Builder permissionType(DocumentPermissionType permissionType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String name;

        private String permissionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionRequest model) {
            name(model.name);
            permissionType(model.permissionType);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType.toString());
            return this;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDocumentPermissionRequest build() {
            return new DescribeDocumentPermissionRequest(this);
        }
    }
}
