/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterTargetFromMaintenanceWindowRequest extends SSMRequest implements
        ToCopyableBuilder<DeregisterTargetFromMaintenanceWindowRequest.Builder, DeregisterTargetFromMaintenanceWindowRequest> {
    private final String windowId;

    private final String windowTargetId;

    private final Boolean safe;

    private DeregisterTargetFromMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.safe = builder.safe;
    }

    /**
     * <p>
     * The ID of the Maintenance Window the target should be removed from.
     * </p>
     * 
     * @return The ID of the Maintenance Window the target should be removed from.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The ID of the target definition to remove.
     * </p>
     * 
     * @return The ID of the target definition to remove.
     */
    public String windowTargetId() {
        return windowTargetId;
    }

    /**
     * <p>
     * The system checks if the target is being referenced by a task. If the target is being referenced, the system
     * returns an error and does not deregister the target from the Maintenance Window.
     * </p>
     * 
     * @return The system checks if the target is being referenced by a task. If the target is being referenced, the
     *         system returns an error and does not deregister the target from the Maintenance Window.
     */
    public Boolean safe() {
        return safe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(safe());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTargetFromMaintenanceWindowRequest)) {
            return false;
        }
        DeregisterTargetFromMaintenanceWindowRequest other = (DeregisterTargetFromMaintenanceWindowRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTargetId(), other.windowTargetId())
                && Objects.equals(safe(), other.safe());
    }

    @Override
    public String toString() {
        return ToString.builder("DeregisterTargetFromMaintenanceWindowRequest").add("WindowId", windowId())
                .add("WindowTargetId", windowTargetId()).add("Safe", safe()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTargetId":
            return Optional.of(clazz.cast(windowTargetId()));
        case "Safe":
            return Optional.of(clazz.cast(safe()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DeregisterTargetFromMaintenanceWindowRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window the target should be removed from.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window the target should be removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The ID of the target definition to remove.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the target definition to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);

        /**
         * <p>
         * The system checks if the target is being referenced by a task. If the target is being referenced, the system
         * returns an error and does not deregister the target from the Maintenance Window.
         * </p>
         * 
         * @param safe
         *        The system checks if the target is being referenced by a task. If the target is being referenced, the
         *        system returns an error and does not deregister the target from the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder safe(Boolean safe);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String windowId;

        private String windowTargetId;

        private Boolean safe;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTargetFromMaintenanceWindowRequest model) {
            windowId(model.windowId);
            windowTargetId(model.windowTargetId);
            safe(model.safe);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public final Boolean getSafe() {
            return safe;
        }

        @Override
        public final Builder safe(Boolean safe) {
            this.safe = safe;
            return this;
        }

        public final void setSafe(Boolean safe) {
            this.safe = safe;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeregisterTargetFromMaintenanceWindowRequest build() {
            return new DeregisterTargetFromMaintenanceWindowRequest(this);
        }
    }
}
