/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationDescription;

@SdkInternalApi
public class AssociationDescriptionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<Instant> DATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Date").build();
    private static final MarshallingInfo<Instant> LASTUPDATEASSOCIATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateAssociationDate").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> OVERVIEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Overview").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").build();
    private static final MarshallingInfo<String> SCHEDULEEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduleExpression").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputLocation").build();
    private static final MarshallingInfo<Instant> LASTEXECUTIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastExecutionDate").build();
    private static final MarshallingInfo<Instant> LASTSUCCESSFULEXECUTIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfulExecutionDate").build();
    private static final AssociationDescriptionMarshaller INSTANCE = new AssociationDescriptionMarshaller();

    public static AssociationDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociationDescription associationDescription, ProtocolMarshaller protocolMarshaller) {
        if (associationDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)associationDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.date(), DATE_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.lastUpdateAssociationDate(), LASTUPDATEASSOCIATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.overview(), OVERVIEW_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(associationDescription.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.associationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall(associationDescription.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.scheduleExpression(), SCHEDULEEXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.outputLocation(), OUTPUTLOCATION_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.lastExecutionDate(), LASTEXECUTIONDATE_BINDING);
            protocolMarshaller.marshall((Object)associationDescription.lastSuccessfulExecutionDate(), LASTSUCCESSFULEXECUTIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

