/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.AssociationStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAssociationStatusRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateAssociationStatusRequest> {
    private final String name;
    private final String instanceId;
    private final AssociationStatus associationStatus;

    private UpdateAssociationStatusRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.associationStatus = builder.associationStatus;
    }

    public String name() {
        return this.name;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public AssociationStatus associationStatus() {
        return this.associationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.associationStatus() == null ? 0 : this.associationStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssociationStatusRequest)) {
            return false;
        }
        UpdateAssociationStatusRequest other = (UpdateAssociationStatusRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.associationStatus() == null ^ this.associationStatus() == null) {
            return false;
        }
        return other.associationStatus() == null || other.associationStatus().equals(this.associationStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.associationStatus() != null) {
            sb.append("AssociationStatus: ").append(this.associationStatus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "AssociationStatus": {
                return Optional.of(clazz.cast(this.associationStatus()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceId;
        private AssociationStatus associationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssociationStatusRequest model) {
            this.name(model.name);
            this.instanceId(model.instanceId);
            this.associationStatus(model.associationStatus);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final AssociationStatus.Builder getAssociationStatus() {
            return this.associationStatus != null ? this.associationStatus.toBuilder() : null;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final void setAssociationStatus(AssociationStatus.BuilderImpl associationStatus) {
            this.associationStatus = associationStatus != null ? associationStatus.build() : null;
        }

        public UpdateAssociationStatusRequest build() {
            return new UpdateAssociationStatusRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateAssociationStatusRequest> {
        public Builder name(String var1);

        public Builder instanceId(String var1);

        public Builder associationStatus(AssociationStatus var1);
    }
}

