/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAssociationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateAssociationRequest> {
    private final String associationId;
    private final Map<String, List<String>> parameters;
    private final String documentVersion;
    private final String scheduleExpression;
    private final InstanceAssociationOutputLocation outputLocation;
    private final String name;
    private final List<Target> targets;

    private UpdateAssociationRequest(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.parameters = builder.parameters;
        this.documentVersion = builder.documentVersion;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.name = builder.name;
        this.targets = builder.targets;
    }

    public String associationId() {
        return this.associationId;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public InstanceAssociationOutputLocation outputLocation() {
        return this.outputLocation;
    }

    public String name() {
        return this.name;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associationId() == null ? 0 : this.associationId().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.scheduleExpression() == null ? 0 : this.scheduleExpression().hashCode());
        hashCode = 31 * hashCode + (this.outputLocation() == null ? 0 : this.outputLocation().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssociationRequest)) {
            return false;
        }
        UpdateAssociationRequest other = (UpdateAssociationRequest)((Object)obj);
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.scheduleExpression() == null ^ this.scheduleExpression() == null) {
            return false;
        }
        if (other.scheduleExpression() != null && !other.scheduleExpression().equals(this.scheduleExpression())) {
            return false;
        }
        if (other.outputLocation() == null ^ this.outputLocation() == null) {
            return false;
        }
        if (other.outputLocation() != null && !other.outputLocation().equals(this.outputLocation())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        return other.targets() == null || other.targets().equals(this.targets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.scheduleExpression() != null) {
            sb.append("ScheduleExpression: ").append(this.scheduleExpression()).append(",");
        }
        if (this.outputLocation() != null) {
            sb.append("OutputLocation: ").append(this.outputLocation()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "ScheduleExpression": {
                return Optional.of(clazz.cast(this.scheduleExpression()));
            }
            case "OutputLocation": {
                return Optional.of(clazz.cast(this.outputLocation()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private Map<String, List<String>> parameters;
        private String documentVersion;
        private String scheduleExpression;
        private InstanceAssociationOutputLocation outputLocation;
        private String name;
        private List<Target> targets;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssociationRequest model) {
            this.associationId(model.associationId);
            this.parameters(model.parameters);
            this.documentVersion(model.documentVersion);
            this.scheduleExpression(model.scheduleExpression);
            this.outputLocation(model.outputLocation);
            this.name(model.name);
            this.targets(model.targets);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public UpdateAssociationRequest build() {
            return new UpdateAssociationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateAssociationRequest> {
        public Builder associationId(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder documentVersion(String var1);

        public Builder scheduleExpression(String var1);

        public Builder outputLocation(InstanceAssociationOutputLocation var1);

        public Builder name(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);
    }
}

