/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.CommandInvocation;
import software.amazon.awssdk.services.ssm.model.CommandInvocationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCommandInvocationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCommandInvocationsResponse> {
    private final List<CommandInvocation> commandInvocations;
    private final String nextToken;

    private ListCommandInvocationsResponse(BuilderImpl builder) {
        this.commandInvocations = builder.commandInvocations;
        this.nextToken = builder.nextToken;
    }

    public List<CommandInvocation> commandInvocations() {
        return this.commandInvocations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.commandInvocations() == null ? 0 : this.commandInvocations().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandInvocationsResponse)) {
            return false;
        }
        ListCommandInvocationsResponse other = (ListCommandInvocationsResponse)((Object)obj);
        if (other.commandInvocations() == null ^ this.commandInvocations() == null) {
            return false;
        }
        if (other.commandInvocations() != null && !other.commandInvocations().equals(this.commandInvocations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.commandInvocations() != null) {
            sb.append("CommandInvocations: ").append(this.commandInvocations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandInvocations": {
                return Optional.of(clazz.cast(this.commandInvocations()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<CommandInvocation> commandInvocations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandInvocationsResponse model) {
            this.commandInvocations(model.commandInvocations);
            this.nextToken(model.nextToken);
        }

        public final Collection<CommandInvocation.Builder> getCommandInvocations() {
            return this.commandInvocations != null ? (Collection)this.commandInvocations.stream().map(CommandInvocation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commandInvocations(Collection<CommandInvocation> commandInvocations) {
            this.commandInvocations = CommandInvocationListCopier.copy(commandInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandInvocations(CommandInvocation ... commandInvocations) {
            this.commandInvocations(Arrays.asList(commandInvocations));
            return this;
        }

        public final void setCommandInvocations(Collection<CommandInvocation.BuilderImpl> commandInvocations) {
            this.commandInvocations = CommandInvocationListCopier.copyFromBuilder(commandInvocations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListCommandInvocationsResponse build() {
            return new ListCommandInvocationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCommandInvocationsResponse> {
        public Builder commandInvocations(Collection<CommandInvocation> var1);

        public Builder commandInvocations(CommandInvocation ... var1);

        public Builder nextToken(String var1);
    }
}

