/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType;
import software.amazon.awssdk.services.ssm.transform.InventoryItemAttributeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryItemAttribute
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryItemAttribute> {
    private final String name;
    private final String dataType;

    private InventoryItemAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
    }

    public String name() {
        return this.name;
    }

    public InventoryAttributeDataType dataType() {
        return InventoryAttributeDataType.fromValue(this.dataType);
    }

    public String dataTypeString() {
        return this.dataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.dataTypeString() == null ? 0 : this.dataTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryItemAttribute)) {
            return false;
        }
        InventoryItemAttribute other = (InventoryItemAttribute)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.dataTypeString() == null ^ this.dataTypeString() == null) {
            return false;
        }
        return other.dataTypeString() == null || other.dataTypeString().equals(this.dataTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.dataTypeString() != null) {
            sb.append("DataType: ").append(this.dataTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DataType": {
                return Optional.of(clazz.cast(this.dataTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryItemAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryItemAttribute model) {
            this.name(model.name);
            this.dataType(model.dataType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(InventoryAttributeDataType dataType) {
            this.dataType(dataType.toString());
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public InventoryItemAttribute build() {
            return new InventoryItemAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryItemAttribute> {
        public Builder name(String var1);

        public Builder dataType(String var1);

        public Builder dataType(InventoryAttributeDataType var1);
    }
}

