/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InstanceAssociationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAssociation
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceAssociation> {
    private final String associationId;
    private final String instanceId;
    private final String content;

    private InstanceAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.instanceId = builder.instanceId;
        this.content = builder.content;
    }

    public String associationId() {
        return this.associationId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associationId() == null ? 0 : this.associationId().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.content() == null ? 0 : this.content().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociation)) {
            return false;
        }
        InstanceAssociation other = (InstanceAssociation)obj;
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.content() == null ^ this.content() == null) {
            return false;
        }
        return other.content() == null || other.content().equals(this.content());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Content": {
                return Optional.of(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String instanceId;
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociation model) {
            this.associationId(model.associationId);
            this.instanceId(model.instanceId);
            this.content(model.content);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public InstanceAssociation build() {
            return new InstanceAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAssociation> {
        public Builder associationId(String var1);

        public Builder instanceId(String var1);

        public Builder content(String var1);
    }
}

