/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.InventoryFilter;
import software.amazon.awssdk.services.ssm.model.InventoryFilterListCopier;
import software.amazon.awssdk.services.ssm.model.ResultAttribute;
import software.amazon.awssdk.services.ssm.model.ResultAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInventoryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetInventoryRequest> {
    private final List<InventoryFilter> filters;
    private final List<ResultAttribute> resultAttributes;
    private final String nextToken;
    private final Integer maxResults;

    private GetInventoryRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.resultAttributes = builder.resultAttributes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<InventoryFilter> filters() {
        return this.filters;
    }

    public List<ResultAttribute> resultAttributes() {
        return this.resultAttributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.resultAttributes() == null ? 0 : this.resultAttributes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryRequest)) {
            return false;
        }
        GetInventoryRequest other = (GetInventoryRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.resultAttributes() == null ^ this.resultAttributes() == null) {
            return false;
        }
        if (other.resultAttributes() != null && !other.resultAttributes().equals(this.resultAttributes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.resultAttributes() != null) {
            sb.append("ResultAttributes: ").append(this.resultAttributes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "ResultAttributes": {
                return Optional.of(clazz.cast(this.resultAttributes()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InventoryFilter> filters;
        private List<ResultAttribute> resultAttributes;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryRequest model) {
            this.filters(model.filters);
            this.resultAttributes(model.resultAttributes);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<InventoryFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(InventoryFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InventoryFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<InventoryFilter.BuilderImpl> filters) {
            this.filters = InventoryFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<ResultAttribute.Builder> getResultAttributes() {
            return this.resultAttributes != null ? (Collection)this.resultAttributes.stream().map(ResultAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultAttributes(Collection<ResultAttribute> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copy(resultAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultAttributes(ResultAttribute ... resultAttributes) {
            this.resultAttributes(Arrays.asList(resultAttributes));
            return this;
        }

        public final void setResultAttributes(Collection<ResultAttribute.BuilderImpl> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copyFromBuilder(resultAttributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public GetInventoryRequest build() {
            return new GetInventoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInventoryRequest> {
        public Builder filters(Collection<InventoryFilter> var1);

        public Builder filters(InventoryFilter ... var1);

        public Builder resultAttributes(Collection<ResultAttribute> var1);

        public Builder resultAttributes(ResultAttribute ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

