/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.PlatformTypeListCopier;
import software.amazon.awssdk.services.ssm.transform.DocumentIdentifierMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentIdentifier> {
    private final String name;
    private final String owner;
    private final List<String> platformTypes;
    private final String documentVersion;
    private final String documentType;
    private final String schemaVersion;

    private DocumentIdentifier(BuilderImpl builder) {
        this.name = builder.name;
        this.owner = builder.owner;
        this.platformTypes = builder.platformTypes;
        this.documentVersion = builder.documentVersion;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public List<PlatformType> platformTypes() {
        return TypeConverter.convert(this.platformTypes, PlatformType::fromValue);
    }

    public List<String> platformTypesStrings() {
        return this.platformTypes;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public String documentTypeString() {
        return this.documentType;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.platformTypesStrings() == null ? 0 : this.platformTypesStrings().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.documentTypeString() == null ? 0 : this.documentTypeString().hashCode());
        hashCode = 31 * hashCode + (this.schemaVersion() == null ? 0 : this.schemaVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.platformTypesStrings() == null ^ this.platformTypesStrings() == null) {
            return false;
        }
        if (other.platformTypesStrings() != null && !other.platformTypesStrings().equals(this.platformTypesStrings())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.documentTypeString() == null ^ this.documentTypeString() == null) {
            return false;
        }
        if (other.documentTypeString() != null && !other.documentTypeString().equals(this.documentTypeString())) {
            return false;
        }
        if (other.schemaVersion() == null ^ this.schemaVersion() == null) {
            return false;
        }
        return other.schemaVersion() == null || other.schemaVersion().equals(this.schemaVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.platformTypesStrings() != null) {
            sb.append("PlatformTypes: ").append(this.platformTypesStrings()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.documentTypeString() != null) {
            sb.append("DocumentType: ").append(this.documentTypeString()).append(",");
        }
        if (this.schemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.schemaVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "PlatformTypes": {
                return Optional.of(clazz.cast(this.platformTypesStrings()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "DocumentType": {
                return Optional.of(clazz.cast(this.documentTypeString()));
            }
            case "SchemaVersion": {
                return Optional.of(clazz.cast(this.schemaVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String owner;
        private List<String> platformTypes;
        private String documentVersion;
        private String documentType;
        private String schemaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentIdentifier model) {
            this.name(model.name);
            this.owner(model.owner);
            this.platformTypes(model.platformTypes);
            this.documentVersion(model.documentVersion);
            this.documentType(model.documentType);
            this.schemaVersion(model.schemaVersion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Collection<String> getPlatformTypes() {
            return this.platformTypes;
        }

        @Override
        public final Builder platformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(String ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes));
            return this;
        }

        public final void setPlatformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public DocumentIdentifier build() {
            return new DocumentIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentIdentifier> {
        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder platformTypes(Collection<String> var1);

        public Builder platformTypes(String ... var1);

        public Builder documentVersion(String var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder schemaVersion(String var1);
    }
}

