/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentityListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePatchBaselinesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribePatchBaselinesResponse> {
    private final List<PatchBaselineIdentity> baselineIdentities;
    private final String nextToken;

    private DescribePatchBaselinesResponse(BuilderImpl builder) {
        this.baselineIdentities = builder.baselineIdentities;
        this.nextToken = builder.nextToken;
    }

    public List<PatchBaselineIdentity> baselineIdentities() {
        return this.baselineIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.baselineIdentities() == null ? 0 : this.baselineIdentities().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchBaselinesResponse)) {
            return false;
        }
        DescribePatchBaselinesResponse other = (DescribePatchBaselinesResponse)((Object)obj);
        if (other.baselineIdentities() == null ^ this.baselineIdentities() == null) {
            return false;
        }
        if (other.baselineIdentities() != null && !other.baselineIdentities().equals(this.baselineIdentities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.baselineIdentities() != null) {
            sb.append("BaselineIdentities: ").append(this.baselineIdentities()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineIdentities": {
                return Optional.of(clazz.cast(this.baselineIdentities()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PatchBaselineIdentity> baselineIdentities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchBaselinesResponse model) {
            this.baselineIdentities(model.baselineIdentities);
            this.nextToken(model.nextToken);
        }

        public final Collection<PatchBaselineIdentity.Builder> getBaselineIdentities() {
            return this.baselineIdentities != null ? (Collection)this.baselineIdentities.stream().map(PatchBaselineIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copy(baselineIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(PatchBaselineIdentity ... baselineIdentities) {
            this.baselineIdentities(Arrays.asList(baselineIdentities));
            return this;
        }

        public final void setBaselineIdentities(Collection<PatchBaselineIdentity.BuilderImpl> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copyFromBuilder(baselineIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribePatchBaselinesResponse build() {
            return new DescribePatchBaselinesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePatchBaselinesResponse> {
        public Builder baselineIdentities(Collection<PatchBaselineIdentity> var1);

        public Builder baselineIdentities(PatchBaselineIdentity ... var1);

        public Builder nextToken(String var1);
    }
}

