/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTargetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowTargetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowTargetsResponse> {
    private final List<MaintenanceWindowTarget> targets;
    private final String nextToken;

    private DescribeMaintenanceWindowTargetsResponse(BuilderImpl builder) {
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowTarget> targets() {
        return this.targets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTargetsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTargetsResponse other = (DescribeMaintenanceWindowTargetsResponse)((Object)obj);
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<MaintenanceWindowTarget> targets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTargetsResponse model) {
            this.targets(model.targets);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTarget.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(MaintenanceWindowTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<MaintenanceWindowTarget> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(MaintenanceWindowTarget ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<MaintenanceWindowTarget.BuilderImpl> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copyFromBuilder(targets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMaintenanceWindowTargetsResponse build() {
            return new DescribeMaintenanceWindowTargetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMaintenanceWindowTargetsResponse> {
        public Builder targets(Collection<MaintenanceWindowTarget> var1);

        public Builder targets(MaintenanceWindowTarget ... var1);

        public Builder nextToken(String var1);
    }
}

