/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowExecutionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowExecutionsResponse> {
    private final List<MaintenanceWindowExecution> windowExecutions;
    private final String nextToken;

    private DescribeMaintenanceWindowExecutionsResponse(BuilderImpl builder) {
        this.windowExecutions = builder.windowExecutions;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowExecution> windowExecutions() {
        return this.windowExecutions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowExecutions() == null ? 0 : this.windowExecutions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionsResponse other = (DescribeMaintenanceWindowExecutionsResponse)((Object)obj);
        if (other.windowExecutions() == null ^ this.windowExecutions() == null) {
            return false;
        }
        if (other.windowExecutions() != null && !other.windowExecutions().equals(this.windowExecutions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowExecutions() != null) {
            sb.append("WindowExecutions: ").append(this.windowExecutions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutions": {
                return Optional.of(clazz.cast(this.windowExecutions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<MaintenanceWindowExecution> windowExecutions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionsResponse model) {
            this.windowExecutions(model.windowExecutions);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecution.Builder> getWindowExecutions() {
            return this.windowExecutions != null ? (Collection)this.windowExecutions.stream().map(MaintenanceWindowExecution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowExecutions(Collection<MaintenanceWindowExecution> windowExecutions) {
            this.windowExecutions = MaintenanceWindowExecutionListCopier.copy(windowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutions(MaintenanceWindowExecution ... windowExecutions) {
            this.windowExecutions(Arrays.asList(windowExecutions));
            return this;
        }

        public final void setWindowExecutions(Collection<MaintenanceWindowExecution.BuilderImpl> windowExecutions) {
            this.windowExecutions = MaintenanceWindowExecutionListCopier.copyFromBuilder(windowExecutions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMaintenanceWindowExecutionsResponse build() {
            return new DescribeMaintenanceWindowExecutionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionsResponse> {
        public Builder windowExecutions(Collection<MaintenanceWindowExecution> var1);

        public Builder windowExecutions(MaintenanceWindowExecution ... var1);

        public Builder nextToken(String var1);
    }
}

