/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CommandInvocationStatus;
import software.amazon.awssdk.services.ssm.model.CommandPlugin;
import software.amazon.awssdk.services.ssm.model.CommandPluginListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.services.ssm.transform.CommandInvocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CommandInvocation
implements StructuredPojo,
ToCopyableBuilder<Builder, CommandInvocation> {
    private final String commandId;
    private final String instanceId;
    private final String instanceName;
    private final String comment;
    private final String documentName;
    private final Instant requestedDateTime;
    private final String status;
    private final String statusDetails;
    private final String traceOutput;
    private final String standardOutputUrl;
    private final String standardErrorUrl;
    private final List<CommandPlugin> commandPlugins;
    private final String serviceRole;
    private final NotificationConfig notificationConfig;

    private CommandInvocation(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.instanceName = builder.instanceName;
        this.comment = builder.comment;
        this.documentName = builder.documentName;
        this.requestedDateTime = builder.requestedDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.traceOutput = builder.traceOutput;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorUrl = builder.standardErrorUrl;
        this.commandPlugins = builder.commandPlugins;
        this.serviceRole = builder.serviceRole;
        this.notificationConfig = builder.notificationConfig;
    }

    public String commandId() {
        return this.commandId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String comment() {
        return this.comment;
    }

    public String documentName() {
        return this.documentName;
    }

    public Instant requestedDateTime() {
        return this.requestedDateTime;
    }

    public CommandInvocationStatus status() {
        return CommandInvocationStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public String traceOutput() {
        return this.traceOutput;
    }

    public String standardOutputUrl() {
        return this.standardOutputUrl;
    }

    public String standardErrorUrl() {
        return this.standardErrorUrl;
    }

    public List<CommandPlugin> commandPlugins() {
        return this.commandPlugins;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.commandId() == null ? 0 : this.commandId().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        hashCode = 31 * hashCode + (this.documentName() == null ? 0 : this.documentName().hashCode());
        hashCode = 31 * hashCode + (this.requestedDateTime() == null ? 0 : this.requestedDateTime().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.statusDetails() == null ? 0 : this.statusDetails().hashCode());
        hashCode = 31 * hashCode + (this.traceOutput() == null ? 0 : this.traceOutput().hashCode());
        hashCode = 31 * hashCode + (this.standardOutputUrl() == null ? 0 : this.standardOutputUrl().hashCode());
        hashCode = 31 * hashCode + (this.standardErrorUrl() == null ? 0 : this.standardErrorUrl().hashCode());
        hashCode = 31 * hashCode + (this.commandPlugins() == null ? 0 : this.commandPlugins().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.notificationConfig() == null ? 0 : this.notificationConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandInvocation)) {
            return false;
        }
        CommandInvocation other = (CommandInvocation)obj;
        if (other.commandId() == null ^ this.commandId() == null) {
            return false;
        }
        if (other.commandId() != null && !other.commandId().equals(this.commandId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.requestedDateTime() == null ^ this.requestedDateTime() == null) {
            return false;
        }
        if (other.requestedDateTime() != null && !other.requestedDateTime().equals(this.requestedDateTime())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.traceOutput() == null ^ this.traceOutput() == null) {
            return false;
        }
        if (other.traceOutput() != null && !other.traceOutput().equals(this.traceOutput())) {
            return false;
        }
        if (other.standardOutputUrl() == null ^ this.standardOutputUrl() == null) {
            return false;
        }
        if (other.standardOutputUrl() != null && !other.standardOutputUrl().equals(this.standardOutputUrl())) {
            return false;
        }
        if (other.standardErrorUrl() == null ^ this.standardErrorUrl() == null) {
            return false;
        }
        if (other.standardErrorUrl() != null && !other.standardErrorUrl().equals(this.standardErrorUrl())) {
            return false;
        }
        if (other.commandPlugins() == null ^ this.commandPlugins() == null) {
            return false;
        }
        if (other.commandPlugins() != null && !other.commandPlugins().equals(this.commandPlugins())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.notificationConfig() == null ^ this.notificationConfig() == null) {
            return false;
        }
        return other.notificationConfig() == null || other.notificationConfig().equals(this.notificationConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.commandId() != null) {
            sb.append("CommandId: ").append(this.commandId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.documentName() != null) {
            sb.append("DocumentName: ").append(this.documentName()).append(",");
        }
        if (this.requestedDateTime() != null) {
            sb.append("RequestedDateTime: ").append(this.requestedDateTime()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.traceOutput() != null) {
            sb.append("TraceOutput: ").append(this.traceOutput()).append(",");
        }
        if (this.standardOutputUrl() != null) {
            sb.append("StandardOutputUrl: ").append(this.standardOutputUrl()).append(",");
        }
        if (this.standardErrorUrl() != null) {
            sb.append("StandardErrorUrl: ").append(this.standardErrorUrl()).append(",");
        }
        if (this.commandPlugins() != null) {
            sb.append("CommandPlugins: ").append(this.commandPlugins()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.notificationConfig() != null) {
            sb.append("NotificationConfig: ").append(this.notificationConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.of(clazz.cast(this.commandId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "InstanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "DocumentName": {
                return Optional.of(clazz.cast(this.documentName()));
            }
            case "RequestedDateTime": {
                return Optional.of(clazz.cast(this.requestedDateTime()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "TraceOutput": {
                return Optional.of(clazz.cast(this.traceOutput()));
            }
            case "StandardOutputUrl": {
                return Optional.of(clazz.cast(this.standardOutputUrl()));
            }
            case "StandardErrorUrl": {
                return Optional.of(clazz.cast(this.standardErrorUrl()));
            }
            case "CommandPlugins": {
                return Optional.of(clazz.cast(this.commandPlugins()));
            }
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "NotificationConfig": {
                return Optional.of(clazz.cast(this.notificationConfig()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandInvocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String commandId;
        private String instanceId;
        private String instanceName;
        private String comment;
        private String documentName;
        private Instant requestedDateTime;
        private String status;
        private String statusDetails;
        private String traceOutput;
        private String standardOutputUrl;
        private String standardErrorUrl;
        private List<CommandPlugin> commandPlugins;
        private String serviceRole;
        private NotificationConfig notificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandInvocation model) {
            this.commandId(model.commandId);
            this.instanceId(model.instanceId);
            this.instanceName(model.instanceName);
            this.comment(model.comment);
            this.documentName(model.documentName);
            this.requestedDateTime(model.requestedDateTime);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.traceOutput(model.traceOutput);
            this.standardOutputUrl(model.standardOutputUrl);
            this.standardErrorUrl(model.standardErrorUrl);
            this.commandPlugins(model.commandPlugins);
            this.serviceRole(model.serviceRole);
            this.notificationConfig(model.notificationConfig);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final Instant getRequestedDateTime() {
            return this.requestedDateTime;
        }

        @Override
        public final Builder requestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
            return this;
        }

        public final void setRequestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandInvocationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getTraceOutput() {
            return this.traceOutput;
        }

        @Override
        public final Builder traceOutput(String traceOutput) {
            this.traceOutput = traceOutput;
            return this;
        }

        public final void setTraceOutput(String traceOutput) {
            this.traceOutput = traceOutput;
        }

        public final String getStandardOutputUrl() {
            return this.standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorUrl() {
            return this.standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        public final Collection<CommandPlugin.Builder> getCommandPlugins() {
            return this.commandPlugins != null ? (Collection)this.commandPlugins.stream().map(CommandPlugin::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commandPlugins(Collection<CommandPlugin> commandPlugins) {
            this.commandPlugins = CommandPluginListCopier.copy(commandPlugins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandPlugins(CommandPlugin ... commandPlugins) {
            this.commandPlugins(Arrays.asList(commandPlugins));
            return this;
        }

        public final void setCommandPlugins(Collection<CommandPlugin.BuilderImpl> commandPlugins) {
            this.commandPlugins = CommandPluginListCopier.copyFromBuilder(commandPlugins);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        public CommandInvocation build() {
            return new CommandInvocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CommandInvocation> {
        public Builder commandId(String var1);

        public Builder instanceId(String var1);

        public Builder instanceName(String var1);

        public Builder comment(String var1);

        public Builder documentName(String var1);

        public Builder requestedDateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(CommandInvocationStatus var1);

        public Builder statusDetails(String var1);

        public Builder traceOutput(String var1);

        public Builder standardOutputUrl(String var1);

        public Builder standardErrorUrl(String var1);

        public Builder commandPlugins(Collection<CommandPlugin> var1);

        public Builder commandPlugins(CommandPlugin ... var1);

        public Builder serviceRole(String var1);

        public Builder notificationConfig(NotificationConfig var1);
    }
}

