/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.services.ssm.model.StepExecutionListCopier;
import software.amazon.awssdk.services.ssm.transform.AutomationExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutomationExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, AutomationExecution> {
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String automationExecutionStatus;
    private final List<StepExecution> stepExecutions;
    private final Map<String, List<String>> parameters;
    private final Map<String, List<String>> outputs;
    private final String failureMessage;

    private AutomationExecution(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.stepExecutions = builder.stepExecutions;
        this.parameters = builder.parameters;
        this.outputs = builder.outputs;
        this.failureMessage = builder.failureMessage;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Instant executionStartTime() {
        return this.executionStartTime;
    }

    public Instant executionEndTime() {
        return this.executionEndTime;
    }

    public AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(this.automationExecutionStatus);
    }

    public String automationExecutionStatusString() {
        return this.automationExecutionStatus;
    }

    public List<StepExecution> stepExecutions() {
        return this.stepExecutions;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.automationExecutionId() == null ? 0 : this.automationExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.documentName() == null ? 0 : this.documentName().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.executionStartTime() == null ? 0 : this.executionStartTime().hashCode());
        hashCode = 31 * hashCode + (this.executionEndTime() == null ? 0 : this.executionEndTime().hashCode());
        hashCode = 31 * hashCode + (this.automationExecutionStatusString() == null ? 0 : this.automationExecutionStatusString().hashCode());
        hashCode = 31 * hashCode + (this.stepExecutions() == null ? 0 : this.stepExecutions().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.outputs() == null ? 0 : this.outputs().hashCode());
        hashCode = 31 * hashCode + (this.failureMessage() == null ? 0 : this.failureMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution)obj;
        if (other.automationExecutionId() == null ^ this.automationExecutionId() == null) {
            return false;
        }
        if (other.automationExecutionId() != null && !other.automationExecutionId().equals(this.automationExecutionId())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.executionStartTime() == null ^ this.executionStartTime() == null) {
            return false;
        }
        if (other.executionStartTime() != null && !other.executionStartTime().equals(this.executionStartTime())) {
            return false;
        }
        if (other.executionEndTime() == null ^ this.executionEndTime() == null) {
            return false;
        }
        if (other.executionEndTime() != null && !other.executionEndTime().equals(this.executionEndTime())) {
            return false;
        }
        if (other.automationExecutionStatusString() == null ^ this.automationExecutionStatusString() == null) {
            return false;
        }
        if (other.automationExecutionStatusString() != null && !other.automationExecutionStatusString().equals(this.automationExecutionStatusString())) {
            return false;
        }
        if (other.stepExecutions() == null ^ this.stepExecutions() == null) {
            return false;
        }
        if (other.stepExecutions() != null && !other.stepExecutions().equals(this.stepExecutions())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.failureMessage() == null ^ this.failureMessage() == null) {
            return false;
        }
        return other.failureMessage() == null || other.failureMessage().equals(this.failureMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(this.automationExecutionId()).append(",");
        }
        if (this.documentName() != null) {
            sb.append("DocumentName: ").append(this.documentName()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.executionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(this.executionStartTime()).append(",");
        }
        if (this.executionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(this.executionEndTime()).append(",");
        }
        if (this.automationExecutionStatusString() != null) {
            sb.append("AutomationExecutionStatus: ").append(this.automationExecutionStatusString()).append(",");
        }
        if (this.stepExecutions() != null) {
            sb.append("StepExecutions: ").append(this.stepExecutions()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.outputs() != null) {
            sb.append("Outputs: ").append(this.outputs()).append(",");
        }
        if (this.failureMessage() != null) {
            sb.append("FailureMessage: ").append(this.failureMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.of(clazz.cast(this.automationExecutionId()));
            }
            case "DocumentName": {
                return Optional.of(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "ExecutionStartTime": {
                return Optional.of(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.of(clazz.cast(this.executionEndTime()));
            }
            case "AutomationExecutionStatus": {
                return Optional.of(clazz.cast(this.automationExecutionStatusString()));
            }
            case "StepExecutions": {
                return Optional.of(clazz.cast(this.stepExecutions()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "Outputs": {
                return Optional.of(clazz.cast(this.outputs()));
            }
            case "FailureMessage": {
                return Optional.of(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomationExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String automationExecutionStatus;
        private List<StepExecution> stepExecutions;
        private Map<String, List<String>> parameters;
        private Map<String, List<String>> outputs;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecution model) {
            this.automationExecutionId(model.automationExecutionId);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.automationExecutionStatus(model.automationExecutionStatus);
            this.stepExecutions(model.stepExecutions);
            this.parameters(model.parameters);
            this.outputs(model.outputs);
            this.failureMessage(model.failureMessage);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getAutomationExecutionStatus() {
            return this.automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final Collection<StepExecution.Builder> getStepExecutions() {
            return this.stepExecutions != null ? (Collection)this.stepExecutions.stream().map(StepExecution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution ... stepExecutions) {
            this.stepExecutions(Arrays.asList(stepExecutions));
            return this;
        }

        public final void setStepExecutions(Collection<StepExecution.BuilderImpl> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copyFromBuilder(stepExecutions);
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public AutomationExecution build() {
            return new AutomationExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutomationExecution> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder stepExecutions(Collection<StepExecution> var1);

        public Builder stepExecutions(StepExecution ... var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder failureMessage(String var1);
    }
}

