/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationOverview;
import software.amazon.awssdk.services.ssm.model.AssociationStatus;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.transform.AssociationDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociationDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, AssociationDescription> {
    private final String name;
    private final String instanceId;
    private final Instant dateValue;
    private final Instant lastUpdateAssociationDate;
    private final AssociationStatus status;
    private final AssociationOverview overview;
    private final String documentVersion;
    private final Map<String, List<String>> parameters;
    private final String associationId;
    private final List<Target> targets;
    private final String scheduleExpression;
    private final InstanceAssociationOutputLocation outputLocation;
    private final Instant lastExecutionDate;
    private final Instant lastSuccessfulExecutionDate;

    private AssociationDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.dateValue = builder.dateValue;
        this.lastUpdateAssociationDate = builder.lastUpdateAssociationDate;
        this.status = builder.status;
        this.overview = builder.overview;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.associationId = builder.associationId;
        this.targets = builder.targets;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.lastSuccessfulExecutionDate = builder.lastSuccessfulExecutionDate;
    }

    public String name() {
        return this.name;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Instant date() {
        return this.dateValue;
    }

    public Instant lastUpdateAssociationDate() {
        return this.lastUpdateAssociationDate;
    }

    public AssociationStatus status() {
        return this.status;
    }

    public AssociationOverview overview() {
        return this.overview;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String associationId() {
        return this.associationId;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public InstanceAssociationOutputLocation outputLocation() {
        return this.outputLocation;
    }

    public Instant lastExecutionDate() {
        return this.lastExecutionDate;
    }

    public Instant lastSuccessfulExecutionDate() {
        return this.lastSuccessfulExecutionDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.date() == null ? 0 : this.date().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdateAssociationDate() == null ? 0 : this.lastUpdateAssociationDate().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.overview() == null ? 0 : this.overview().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.associationId() == null ? 0 : this.associationId().hashCode());
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        hashCode = 31 * hashCode + (this.scheduleExpression() == null ? 0 : this.scheduleExpression().hashCode());
        hashCode = 31 * hashCode + (this.outputLocation() == null ? 0 : this.outputLocation().hashCode());
        hashCode = 31 * hashCode + (this.lastExecutionDate() == null ? 0 : this.lastExecutionDate().hashCode());
        hashCode = 31 * hashCode + (this.lastSuccessfulExecutionDate() == null ? 0 : this.lastSuccessfulExecutionDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationDescription)) {
            return false;
        }
        AssociationDescription other = (AssociationDescription)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.lastUpdateAssociationDate() == null ^ this.lastUpdateAssociationDate() == null) {
            return false;
        }
        if (other.lastUpdateAssociationDate() != null && !other.lastUpdateAssociationDate().equals(this.lastUpdateAssociationDate())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.overview() == null ^ this.overview() == null) {
            return false;
        }
        if (other.overview() != null && !other.overview().equals(this.overview())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.scheduleExpression() == null ^ this.scheduleExpression() == null) {
            return false;
        }
        if (other.scheduleExpression() != null && !other.scheduleExpression().equals(this.scheduleExpression())) {
            return false;
        }
        if (other.outputLocation() == null ^ this.outputLocation() == null) {
            return false;
        }
        if (other.outputLocation() != null && !other.outputLocation().equals(this.outputLocation())) {
            return false;
        }
        if (other.lastExecutionDate() == null ^ this.lastExecutionDate() == null) {
            return false;
        }
        if (other.lastExecutionDate() != null && !other.lastExecutionDate().equals(this.lastExecutionDate())) {
            return false;
        }
        if (other.lastSuccessfulExecutionDate() == null ^ this.lastSuccessfulExecutionDate() == null) {
            return false;
        }
        return other.lastSuccessfulExecutionDate() == null || other.lastSuccessfulExecutionDate().equals(this.lastSuccessfulExecutionDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.date() != null) {
            sb.append("Date: ").append(this.date()).append(",");
        }
        if (this.lastUpdateAssociationDate() != null) {
            sb.append("LastUpdateAssociationDate: ").append(this.lastUpdateAssociationDate()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.overview() != null) {
            sb.append("Overview: ").append(this.overview()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.scheduleExpression() != null) {
            sb.append("ScheduleExpression: ").append(this.scheduleExpression()).append(",");
        }
        if (this.outputLocation() != null) {
            sb.append("OutputLocation: ").append(this.outputLocation()).append(",");
        }
        if (this.lastExecutionDate() != null) {
            sb.append("LastExecutionDate: ").append(this.lastExecutionDate()).append(",");
        }
        if (this.lastSuccessfulExecutionDate() != null) {
            sb.append("LastSuccessfulExecutionDate: ").append(this.lastSuccessfulExecutionDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Date": {
                return Optional.of(clazz.cast(this.date()));
            }
            case "LastUpdateAssociationDate": {
                return Optional.of(clazz.cast(this.lastUpdateAssociationDate()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Overview": {
                return Optional.of(clazz.cast(this.overview()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "ScheduleExpression": {
                return Optional.of(clazz.cast(this.scheduleExpression()));
            }
            case "OutputLocation": {
                return Optional.of(clazz.cast(this.outputLocation()));
            }
            case "LastExecutionDate": {
                return Optional.of(clazz.cast(this.lastExecutionDate()));
            }
            case "LastSuccessfulExecutionDate": {
                return Optional.of(clazz.cast(this.lastSuccessfulExecutionDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceId;
        private Instant dateValue;
        private Instant lastUpdateAssociationDate;
        private AssociationStatus status;
        private AssociationOverview overview;
        private String documentVersion;
        private Map<String, List<String>> parameters;
        private String associationId;
        private List<Target> targets;
        private String scheduleExpression;
        private InstanceAssociationOutputLocation outputLocation;
        private Instant lastExecutionDate;
        private Instant lastSuccessfulExecutionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationDescription model) {
            this.name(model.name);
            this.instanceId(model.instanceId);
            this.date(model.dateValue);
            this.lastUpdateAssociationDate(model.lastUpdateAssociationDate);
            this.status(model.status);
            this.overview(model.overview);
            this.documentVersion(model.documentVersion);
            this.parameters(model.parameters);
            this.associationId(model.associationId);
            this.targets(model.targets);
            this.scheduleExpression(model.scheduleExpression);
            this.outputLocation(model.outputLocation);
            this.lastExecutionDate(model.lastExecutionDate);
            this.lastSuccessfulExecutionDate(model.lastSuccessfulExecutionDate);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Instant getDate() {
            return this.dateValue;
        }

        @Override
        public final Builder date(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDate(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public final Instant getLastUpdateAssociationDate() {
            return this.lastUpdateAssociationDate;
        }

        @Override
        public final Builder lastUpdateAssociationDate(Instant lastUpdateAssociationDate) {
            this.lastUpdateAssociationDate = lastUpdateAssociationDate;
            return this;
        }

        public final void setLastUpdateAssociationDate(Instant lastUpdateAssociationDate) {
            this.lastUpdateAssociationDate = lastUpdateAssociationDate;
        }

        public final AssociationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(AssociationStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(AssociationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final AssociationOverview.Builder getOverview() {
            return this.overview != null ? this.overview.toBuilder() : null;
        }

        @Override
        public final Builder overview(AssociationOverview overview) {
            this.overview = overview;
            return this;
        }

        public final void setOverview(AssociationOverview.BuilderImpl overview) {
            this.overview = overview != null ? overview.build() : null;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final Instant getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        public final Instant getLastSuccessfulExecutionDate() {
            return this.lastSuccessfulExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate) {
            this.lastSuccessfulExecutionDate = lastSuccessfulExecutionDate;
            return this;
        }

        public final void setLastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate) {
            this.lastSuccessfulExecutionDate = lastSuccessfulExecutionDate;
        }

        public AssociationDescription build() {
            return new AssociationDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociationDescription> {
        public Builder name(String var1);

        public Builder instanceId(String var1);

        public Builder date(Instant var1);

        public Builder lastUpdateAssociationDate(Instant var1);

        public Builder status(AssociationStatus var1);

        public Builder overview(AssociationOverview var1);

        public Builder documentVersion(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder associationId(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder scheduleExpression(String var1);

        public Builder outputLocation(InstanceAssociationOutputLocation var1);

        public Builder lastExecutionDate(Instant var1);

        public Builder lastSuccessfulExecutionDate(Instant var1);
    }
}

