/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentDescription;
import software.amazon.awssdk.services.ssm.transform.DocumentParameterUnmarshaller;

public class DocumentDescriptionUnmarshaller
implements Unmarshaller<DocumentDescription, JsonUnmarshallerContext> {
    private static final DocumentDescriptionUnmarshaller INSTANCE = new DocumentDescriptionUnmarshaller();

    public DocumentDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentDescription.Builder documentDescriptionBuilder = DocumentDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Sha1", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.sha1((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Hash", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.hash((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HashType", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.hashType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Owner", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.owner((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedDate", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.createdDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DocumentVersion", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.documentVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.parameters(new ListUnmarshaller((Unmarshaller)DocumentParameterUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("PlatformTypes", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.platformTypes(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("DocumentType", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.documentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SchemaVersion", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.schemaVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LatestVersion", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.latestVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultVersion", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.defaultVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DocumentDescription)documentDescriptionBuilder.build();
    }

    public static DocumentDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

