/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.services.ssm.transform.NotificationConfigUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.TargetUnmarshaller;

public class CommandUnmarshaller
implements Unmarshaller<Command, JsonUnmarshallerContext> {
    private static final CommandUnmarshaller INSTANCE = new CommandUnmarshaller();

    public Command unmarshall(JsonUnmarshallerContext context) throws Exception {
        Command.Builder commandBuilder = Command.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CommandId", targetDepth)) {
                    context.nextToken();
                    commandBuilder.commandId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DocumentName", targetDepth)) {
                    context.nextToken();
                    commandBuilder.documentName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Comment", targetDepth)) {
                    context.nextToken();
                    commandBuilder.comment((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExpiresAfter", targetDepth)) {
                    context.nextToken();
                    commandBuilder.expiresAfter((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    commandBuilder.parameters(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("InstanceIds", targetDepth)) {
                    context.nextToken();
                    commandBuilder.instanceIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Targets", targetDepth)) {
                    context.nextToken();
                    commandBuilder.targets(new ListUnmarshaller((Unmarshaller)TargetUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("RequestedDateTime", targetDepth)) {
                    context.nextToken();
                    commandBuilder.requestedDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    commandBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StatusDetails", targetDepth)) {
                    context.nextToken();
                    commandBuilder.statusDetails((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputS3Region", targetDepth)) {
                    context.nextToken();
                    commandBuilder.outputS3Region((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputS3BucketName", targetDepth)) {
                    context.nextToken();
                    commandBuilder.outputS3BucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputS3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    commandBuilder.outputS3KeyPrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxConcurrency", targetDepth)) {
                    context.nextToken();
                    commandBuilder.maxConcurrency((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxErrors", targetDepth)) {
                    context.nextToken();
                    commandBuilder.maxErrors((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TargetCount", targetDepth)) {
                    context.nextToken();
                    commandBuilder.targetCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("CompletedCount", targetDepth)) {
                    context.nextToken();
                    commandBuilder.completedCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ErrorCount", targetDepth)) {
                    context.nextToken();
                    commandBuilder.errorCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ServiceRole", targetDepth)) {
                    context.nextToken();
                    commandBuilder.serviceRole((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NotificationConfig", targetDepth)) {
                    context.nextToken();
                    commandBuilder.notificationConfig(NotificationConfigUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Command)commandBuilder.build();
    }

    public static CommandUnmarshaller getInstance() {
        return INSTANCE;
    }
}

