/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchFilter;
import software.amazon.awssdk.services.ssm.model.PatchFilterListCopier;
import software.amazon.awssdk.services.ssm.transform.PatchFilterGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchFilterGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchFilterGroup> {
    private final List<PatchFilter> patchFilters;

    private PatchFilterGroup(BuilderImpl builder) {
        this.patchFilters = builder.patchFilters;
    }

    public List<PatchFilter> patchFilters() {
        return this.patchFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.patchFilters() == null ? 0 : this.patchFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilterGroup)) {
            return false;
        }
        PatchFilterGroup other = (PatchFilterGroup)obj;
        if (other.patchFilters() == null ^ this.patchFilters() == null) {
            return false;
        }
        return other.patchFilters() == null || other.patchFilters().equals(this.patchFilters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.patchFilters() != null) {
            sb.append("PatchFilters: ").append(this.patchFilters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchFilterGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PatchFilter> patchFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchFilterGroup model) {
            this.setPatchFilters(model.patchFilters);
        }

        public final Collection<PatchFilter> getPatchFilters() {
            return this.patchFilters;
        }

        @Override
        public final Builder patchFilters(Collection<PatchFilter> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copy(patchFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(PatchFilter ... patchFilters) {
            this.patchFilters(Arrays.asList(patchFilters));
            return this;
        }

        public final void setPatchFilters(Collection<PatchFilter> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copy(patchFilters);
        }

        public PatchFilterGroup build() {
            return new PatchFilterGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchFilterGroup> {
        public Builder patchFilters(Collection<PatchFilter> var1);

        public Builder patchFilters(PatchFilter ... var1);
    }
}

