/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilterValueSetCopier;
import software.amazon.awssdk.services.ssm.transform.InstanceInformationFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceInformationFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceInformationFilter> {
    private final String key;
    private final List<String> valueSet;

    private InstanceInformationFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.valueSet = builder.valueSet;
    }

    public String key() {
        return this.key;
    }

    public List<String> valueSet() {
        return this.valueSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.valueSet() == null ? 0 : this.valueSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformationFilter)) {
            return false;
        }
        InstanceInformationFilter other = (InstanceInformationFilter)obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.valueSet() == null ^ this.valueSet() == null) {
            return false;
        }
        return other.valueSet() == null || other.valueSet().equals(this.valueSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.valueSet() != null) {
            sb.append("ValueSet: ").append(this.valueSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInformationFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> valueSet;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformationFilter model) {
            this.setKey(model.key);
            this.setValueSet(model.valueSet);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(InstanceInformationFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValueSet() {
            return this.valueSet;
        }

        @Override
        public final Builder valueSet(Collection<String> valueSet) {
            this.valueSet = InstanceInformationFilterValueSetCopier.copy(valueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueSet(String ... valueSet) {
            this.valueSet(Arrays.asList(valueSet));
            return this;
        }

        public final void setValueSet(Collection<String> valueSet) {
            this.valueSet = InstanceInformationFilterValueSetCopier.copy(valueSet);
        }

        public InstanceInformationFilter build() {
            return new InstanceInformationFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceInformationFilter> {
        public Builder key(String var1);

        public Builder key(InstanceInformationFilterKey var1);

        public Builder valueSet(Collection<String> var1);

        public Builder valueSet(String ... var1);
    }
}

