/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CommandStatus;
import software.amazon.awssdk.services.ssm.model.InstanceIdListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.transform.CommandMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Command
implements StructuredPojo,
ToCopyableBuilder<Builder, Command> {
    private final String commandId;
    private final String documentName;
    private final String comment;
    private final Instant expiresAfter;
    private final Map<String, List<String>> parameters;
    private final List<String> instanceIds;
    private final List<Target> targets;
    private final Instant requestedDateTime;
    private final String status;
    private final String statusDetails;
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final String maxConcurrency;
    private final String maxErrors;
    private final Integer targetCount;
    private final Integer completedCount;
    private final Integer errorCount;
    private final String serviceRole;
    private final NotificationConfig notificationConfig;

    private Command(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.documentName = builder.documentName;
        this.comment = builder.comment;
        this.expiresAfter = builder.expiresAfter;
        this.parameters = builder.parameters;
        this.instanceIds = builder.instanceIds;
        this.targets = builder.targets;
        this.requestedDateTime = builder.requestedDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.targetCount = builder.targetCount;
        this.completedCount = builder.completedCount;
        this.errorCount = builder.errorCount;
        this.serviceRole = builder.serviceRole;
        this.notificationConfig = builder.notificationConfig;
    }

    public String commandId() {
        return this.commandId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String comment() {
        return this.comment;
    }

    public Instant expiresAfter() {
        return this.expiresAfter;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public Instant requestedDateTime() {
        return this.requestedDateTime;
    }

    public String status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public String outputS3Region() {
        return this.outputS3Region;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public Integer targetCount() {
        return this.targetCount;
    }

    public Integer completedCount() {
        return this.completedCount;
    }

    public Integer errorCount() {
        return this.errorCount;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.commandId() == null ? 0 : this.commandId().hashCode());
        hashCode = 31 * hashCode + (this.documentName() == null ? 0 : this.documentName().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        hashCode = 31 * hashCode + (this.expiresAfter() == null ? 0 : this.expiresAfter().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.instanceIds() == null ? 0 : this.instanceIds().hashCode());
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        hashCode = 31 * hashCode + (this.requestedDateTime() == null ? 0 : this.requestedDateTime().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusDetails() == null ? 0 : this.statusDetails().hashCode());
        hashCode = 31 * hashCode + (this.outputS3Region() == null ? 0 : this.outputS3Region().hashCode());
        hashCode = 31 * hashCode + (this.outputS3BucketName() == null ? 0 : this.outputS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.outputS3KeyPrefix() == null ? 0 : this.outputS3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.maxConcurrency() == null ? 0 : this.maxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.maxErrors() == null ? 0 : this.maxErrors().hashCode());
        hashCode = 31 * hashCode + (this.targetCount() == null ? 0 : this.targetCount().hashCode());
        hashCode = 31 * hashCode + (this.completedCount() == null ? 0 : this.completedCount().hashCode());
        hashCode = 31 * hashCode + (this.errorCount() == null ? 0 : this.errorCount().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.notificationConfig() == null ? 0 : this.notificationConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        if (other.commandId() == null ^ this.commandId() == null) {
            return false;
        }
        if (other.commandId() != null && !other.commandId().equals(this.commandId())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.expiresAfter() == null ^ this.expiresAfter() == null) {
            return false;
        }
        if (other.expiresAfter() != null && !other.expiresAfter().equals(this.expiresAfter())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.requestedDateTime() == null ^ this.requestedDateTime() == null) {
            return false;
        }
        if (other.requestedDateTime() != null && !other.requestedDateTime().equals(this.requestedDateTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.outputS3Region() == null ^ this.outputS3Region() == null) {
            return false;
        }
        if (other.outputS3Region() != null && !other.outputS3Region().equals(this.outputS3Region())) {
            return false;
        }
        if (other.outputS3BucketName() == null ^ this.outputS3BucketName() == null) {
            return false;
        }
        if (other.outputS3BucketName() != null && !other.outputS3BucketName().equals(this.outputS3BucketName())) {
            return false;
        }
        if (other.outputS3KeyPrefix() == null ^ this.outputS3KeyPrefix() == null) {
            return false;
        }
        if (other.outputS3KeyPrefix() != null && !other.outputS3KeyPrefix().equals(this.outputS3KeyPrefix())) {
            return false;
        }
        if (other.maxConcurrency() == null ^ this.maxConcurrency() == null) {
            return false;
        }
        if (other.maxConcurrency() != null && !other.maxConcurrency().equals(this.maxConcurrency())) {
            return false;
        }
        if (other.maxErrors() == null ^ this.maxErrors() == null) {
            return false;
        }
        if (other.maxErrors() != null && !other.maxErrors().equals(this.maxErrors())) {
            return false;
        }
        if (other.targetCount() == null ^ this.targetCount() == null) {
            return false;
        }
        if (other.targetCount() != null && !other.targetCount().equals(this.targetCount())) {
            return false;
        }
        if (other.completedCount() == null ^ this.completedCount() == null) {
            return false;
        }
        if (other.completedCount() != null && !other.completedCount().equals(this.completedCount())) {
            return false;
        }
        if (other.errorCount() == null ^ this.errorCount() == null) {
            return false;
        }
        if (other.errorCount() != null && !other.errorCount().equals(this.errorCount())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.notificationConfig() == null ^ this.notificationConfig() == null) {
            return false;
        }
        return other.notificationConfig() == null || other.notificationConfig().equals(this.notificationConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commandId() != null) {
            sb.append("CommandId: ").append(this.commandId()).append(",");
        }
        if (this.documentName() != null) {
            sb.append("DocumentName: ").append(this.documentName()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.expiresAfter() != null) {
            sb.append("ExpiresAfter: ").append(this.expiresAfter()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.requestedDateTime() != null) {
            sb.append("RequestedDateTime: ").append(this.requestedDateTime()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.outputS3Region() != null) {
            sb.append("OutputS3Region: ").append(this.outputS3Region()).append(",");
        }
        if (this.outputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(this.outputS3BucketName()).append(",");
        }
        if (this.outputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(this.outputS3KeyPrefix()).append(",");
        }
        if (this.maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.maxConcurrency()).append(",");
        }
        if (this.maxErrors() != null) {
            sb.append("MaxErrors: ").append(this.maxErrors()).append(",");
        }
        if (this.targetCount() != null) {
            sb.append("TargetCount: ").append(this.targetCount()).append(",");
        }
        if (this.completedCount() != null) {
            sb.append("CompletedCount: ").append(this.completedCount()).append(",");
        }
        if (this.errorCount() != null) {
            sb.append("ErrorCount: ").append(this.errorCount()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.notificationConfig() != null) {
            sb.append("NotificationConfig: ").append(this.notificationConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String commandId;
        private String documentName;
        private String comment;
        private Instant expiresAfter;
        private Map<String, List<String>> parameters;
        private List<String> instanceIds;
        private List<Target> targets;
        private Instant requestedDateTime;
        private String status;
        private String statusDetails;
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private String maxConcurrency;
        private String maxErrors;
        private Integer targetCount;
        private Integer completedCount;
        private Integer errorCount;
        private String serviceRole;
        private NotificationConfig notificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            this.setCommandId(model.commandId);
            this.setDocumentName(model.documentName);
            this.setComment(model.comment);
            this.setExpiresAfter(model.expiresAfter);
            this.setParameters(model.parameters);
            this.setInstanceIds(model.instanceIds);
            this.setTargets(model.targets);
            this.setRequestedDateTime(model.requestedDateTime);
            this.setStatus(model.status);
            this.setStatusDetails(model.statusDetails);
            this.setOutputS3Region(model.outputS3Region);
            this.setOutputS3BucketName(model.outputS3BucketName);
            this.setOutputS3KeyPrefix(model.outputS3KeyPrefix);
            this.setMaxConcurrency(model.maxConcurrency);
            this.setMaxErrors(model.maxErrors);
            this.setTargetCount(model.targetCount);
            this.setCompletedCount(model.completedCount);
            this.setErrorCount(model.errorCount);
            this.setServiceRole(model.serviceRole);
            this.setNotificationConfig(model.notificationConfig);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Instant getExpiresAfter() {
            return this.expiresAfter;
        }

        @Override
        public final Builder expiresAfter(Instant expiresAfter) {
            this.expiresAfter = expiresAfter;
            return this;
        }

        public final void setExpiresAfter(Instant expiresAfter) {
            this.expiresAfter = expiresAfter;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        public final Collection<Target> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        public final Instant getRequestedDateTime() {
            return this.requestedDateTime;
        }

        @Override
        public final Builder requestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
            return this;
        }

        public final void setRequestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final Integer getTargetCount() {
            return this.targetCount;
        }

        @Override
        public final Builder targetCount(Integer targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public final void setTargetCount(Integer targetCount) {
            this.targetCount = targetCount;
        }

        public final Integer getCompletedCount() {
            return this.completedCount;
        }

        @Override
        public final Builder completedCount(Integer completedCount) {
            this.completedCount = completedCount;
            return this;
        }

        public final void setCompletedCount(Integer completedCount) {
            this.completedCount = completedCount;
        }

        public final Integer getErrorCount() {
            return this.errorCount;
        }

        @Override
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final NotificationConfig getNotificationConfig() {
            return this.notificationConfig;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
        }

        public Command build() {
            return new Command(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Command> {
        public Builder commandId(String var1);

        public Builder documentName(String var1);

        public Builder comment(String var1);

        public Builder expiresAfter(Instant var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder requestedDateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(CommandStatus var1);

        public Builder statusDetails(String var1);

        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder targetCount(Integer var1);

        public Builder completedCount(Integer var1);

        public Builder errorCount(Integer var1);

        public Builder serviceRole(String var1);

        public Builder notificationConfig(NotificationConfig var1);
    }
}

