/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.S3OutputUrlMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3OutputUrl
implements StructuredPojo,
ToCopyableBuilder<Builder, S3OutputUrl> {
    private final String outputUrl;

    private S3OutputUrl(BuilderImpl builder) {
        this.outputUrl = builder.outputUrl;
    }

    public String outputUrl() {
        return this.outputUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputUrl() == null ? 0 : this.outputUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputUrl)) {
            return false;
        }
        S3OutputUrl other = (S3OutputUrl)obj;
        if (other.outputUrl() == null ^ this.outputUrl() == null) {
            return false;
        }
        return other.outputUrl() == null || other.outputUrl().equals(this.outputUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.outputUrl() != null) {
            sb.append("OutputUrl: ").append(this.outputUrl()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3OutputUrlMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputUrl model) {
            this.setOutputUrl(model.outputUrl);
        }

        public final String getOutputUrl() {
            return this.outputUrl;
        }

        @Override
        public final Builder outputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
        }

        public S3OutputUrl build() {
            return new S3OutputUrl(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3OutputUrl> {
        public Builder outputUrl(String var1);
    }
}

