/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilter;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilterListCopier;
import software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilter;
import software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceInformationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeInstanceInformationRequest> {
    private final List<InstanceInformationFilter> instanceInformationFilterList;
    private final List<InstanceInformationStringFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeInstanceInformationRequest(BuilderImpl builder) {
        this.instanceInformationFilterList = builder.instanceInformationFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceInformationFilter> instanceInformationFilterList() {
        return this.instanceInformationFilterList;
    }

    public List<InstanceInformationStringFilter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceInformationFilterList() == null ? 0 : this.instanceInformationFilterList().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationRequest)) {
            return false;
        }
        DescribeInstanceInformationRequest other = (DescribeInstanceInformationRequest)((Object)obj);
        if (other.instanceInformationFilterList() == null ^ this.instanceInformationFilterList() == null) {
            return false;
        }
        if (other.instanceInformationFilterList() != null && !other.instanceInformationFilterList().equals(this.instanceInformationFilterList())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceInformationFilterList() != null) {
            sb.append("InstanceInformationFilterList: ").append(this.instanceInformationFilterList()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceInformationFilter> instanceInformationFilterList;
        private List<InstanceInformationStringFilter> filters;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationRequest model) {
            this.setInstanceInformationFilterList(model.instanceInformationFilterList);
            this.setFilters(model.filters);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<InstanceInformationFilter> getInstanceInformationFilterList() {
            return this.instanceInformationFilterList;
        }

        @Override
        public final Builder instanceInformationFilterList(Collection<InstanceInformationFilter> instanceInformationFilterList) {
            this.instanceInformationFilterList = InstanceInformationFilterListCopier.copy(instanceInformationFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationFilterList(InstanceInformationFilter ... instanceInformationFilterList) {
            this.instanceInformationFilterList(Arrays.asList(instanceInformationFilterList));
            return this;
        }

        public final void setInstanceInformationFilterList(Collection<InstanceInformationFilter> instanceInformationFilterList) {
            this.instanceInformationFilterList = InstanceInformationFilterListCopier.copy(instanceInformationFilterList);
        }

        public final Collection<InstanceInformationStringFilter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<InstanceInformationStringFilter> filters) {
            this.filters = InstanceInformationStringFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InstanceInformationStringFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<InstanceInformationStringFilter> filters) {
            this.filters = InstanceInformationStringFilterListCopier.copy(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstanceInformationRequest build() {
            return new DescribeInstanceInformationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstanceInformationRequest> {
        public Builder instanceInformationFilterList(Collection<InstanceInformationFilter> var1);

        public Builder instanceInformationFilterList(InstanceInformationFilter ... var1);

        public Builder filters(Collection<InstanceInformationStringFilter> var1);

        public Builder filters(InstanceInformationStringFilter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

