/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfosCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceAssociationsStatusResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstanceAssociationsStatusResponse> {
    private final List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos;
    private final String nextToken;

    private DescribeInstanceAssociationsStatusResponse(BuilderImpl builder) {
        this.instanceAssociationStatusInfos = builder.instanceAssociationStatusInfos;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos() {
        return this.instanceAssociationStatusInfos;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceAssociationStatusInfos() == null ? 0 : this.instanceAssociationStatusInfos().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAssociationsStatusResponse)) {
            return false;
        }
        DescribeInstanceAssociationsStatusResponse other = (DescribeInstanceAssociationsStatusResponse)((Object)obj);
        if (other.instanceAssociationStatusInfos() == null ^ this.instanceAssociationStatusInfos() == null) {
            return false;
        }
        if (other.instanceAssociationStatusInfos() != null && !other.instanceAssociationStatusInfos().equals(this.instanceAssociationStatusInfos())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceAssociationStatusInfos() != null) {
            sb.append("InstanceAssociationStatusInfos: ").append(this.instanceAssociationStatusInfos()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAssociationsStatusResponse model) {
            this.setInstanceAssociationStatusInfos(model.instanceAssociationStatusInfos);
            this.setNextToken(model.nextToken);
        }

        public final Collection<InstanceAssociationStatusInfo> getInstanceAssociationStatusInfos() {
            return this.instanceAssociationStatusInfos;
        }

        @Override
        public final Builder instanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier.copy(instanceAssociationStatusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo ... instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos(Arrays.asList(instanceAssociationStatusInfos));
            return this;
        }

        public final void setInstanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier.copy(instanceAssociationStatusInfos);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstanceAssociationsStatusResponse build() {
            return new DescribeInstanceAssociationsStatusResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstanceAssociationsStatusResponse> {
        public Builder instanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo> var1);

        public Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo ... var1);

        public Builder nextToken(String var1);
    }
}

