/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CommandPluginStatus;
import software.amazon.awssdk.services.ssm.transform.CommandPluginMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CommandPlugin
implements StructuredPojo,
ToCopyableBuilder<Builder, CommandPlugin> {
    private final String name;
    private final String status;
    private final String statusDetails;
    private final Integer responseCode;
    private final Instant responseStartDateTime;
    private final Instant responseFinishDateTime;
    private final String output;
    private final String standardOutputUrl;
    private final String standardErrorUrl;
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;

    private CommandPlugin(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.responseCode = builder.responseCode;
        this.responseStartDateTime = builder.responseStartDateTime;
        this.responseFinishDateTime = builder.responseFinishDateTime;
        this.output = builder.output;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorUrl = builder.standardErrorUrl;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
    }

    public String name() {
        return this.name;
    }

    public String status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Integer responseCode() {
        return this.responseCode;
    }

    public Instant responseStartDateTime() {
        return this.responseStartDateTime;
    }

    public Instant responseFinishDateTime() {
        return this.responseFinishDateTime;
    }

    public String output() {
        return this.output;
    }

    public String standardOutputUrl() {
        return this.standardOutputUrl;
    }

    public String standardErrorUrl() {
        return this.standardErrorUrl;
    }

    public String outputS3Region() {
        return this.outputS3Region;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusDetails() == null ? 0 : this.statusDetails().hashCode());
        hashCode = 31 * hashCode + (this.responseCode() == null ? 0 : this.responseCode().hashCode());
        hashCode = 31 * hashCode + (this.responseStartDateTime() == null ? 0 : this.responseStartDateTime().hashCode());
        hashCode = 31 * hashCode + (this.responseFinishDateTime() == null ? 0 : this.responseFinishDateTime().hashCode());
        hashCode = 31 * hashCode + (this.output() == null ? 0 : this.output().hashCode());
        hashCode = 31 * hashCode + (this.standardOutputUrl() == null ? 0 : this.standardOutputUrl().hashCode());
        hashCode = 31 * hashCode + (this.standardErrorUrl() == null ? 0 : this.standardErrorUrl().hashCode());
        hashCode = 31 * hashCode + (this.outputS3Region() == null ? 0 : this.outputS3Region().hashCode());
        hashCode = 31 * hashCode + (this.outputS3BucketName() == null ? 0 : this.outputS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.outputS3KeyPrefix() == null ? 0 : this.outputS3KeyPrefix().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandPlugin)) {
            return false;
        }
        CommandPlugin other = (CommandPlugin)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.responseCode() == null ^ this.responseCode() == null) {
            return false;
        }
        if (other.responseCode() != null && !other.responseCode().equals(this.responseCode())) {
            return false;
        }
        if (other.responseStartDateTime() == null ^ this.responseStartDateTime() == null) {
            return false;
        }
        if (other.responseStartDateTime() != null && !other.responseStartDateTime().equals(this.responseStartDateTime())) {
            return false;
        }
        if (other.responseFinishDateTime() == null ^ this.responseFinishDateTime() == null) {
            return false;
        }
        if (other.responseFinishDateTime() != null && !other.responseFinishDateTime().equals(this.responseFinishDateTime())) {
            return false;
        }
        if (other.output() == null ^ this.output() == null) {
            return false;
        }
        if (other.output() != null && !other.output().equals(this.output())) {
            return false;
        }
        if (other.standardOutputUrl() == null ^ this.standardOutputUrl() == null) {
            return false;
        }
        if (other.standardOutputUrl() != null && !other.standardOutputUrl().equals(this.standardOutputUrl())) {
            return false;
        }
        if (other.standardErrorUrl() == null ^ this.standardErrorUrl() == null) {
            return false;
        }
        if (other.standardErrorUrl() != null && !other.standardErrorUrl().equals(this.standardErrorUrl())) {
            return false;
        }
        if (other.outputS3Region() == null ^ this.outputS3Region() == null) {
            return false;
        }
        if (other.outputS3Region() != null && !other.outputS3Region().equals(this.outputS3Region())) {
            return false;
        }
        if (other.outputS3BucketName() == null ^ this.outputS3BucketName() == null) {
            return false;
        }
        if (other.outputS3BucketName() != null && !other.outputS3BucketName().equals(this.outputS3BucketName())) {
            return false;
        }
        if (other.outputS3KeyPrefix() == null ^ this.outputS3KeyPrefix() == null) {
            return false;
        }
        return other.outputS3KeyPrefix() == null || other.outputS3KeyPrefix().equals(this.outputS3KeyPrefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.responseCode() != null) {
            sb.append("ResponseCode: ").append(this.responseCode()).append(",");
        }
        if (this.responseStartDateTime() != null) {
            sb.append("ResponseStartDateTime: ").append(this.responseStartDateTime()).append(",");
        }
        if (this.responseFinishDateTime() != null) {
            sb.append("ResponseFinishDateTime: ").append(this.responseFinishDateTime()).append(",");
        }
        if (this.output() != null) {
            sb.append("Output: ").append(this.output()).append(",");
        }
        if (this.standardOutputUrl() != null) {
            sb.append("StandardOutputUrl: ").append(this.standardOutputUrl()).append(",");
        }
        if (this.standardErrorUrl() != null) {
            sb.append("StandardErrorUrl: ").append(this.standardErrorUrl()).append(",");
        }
        if (this.outputS3Region() != null) {
            sb.append("OutputS3Region: ").append(this.outputS3Region()).append(",");
        }
        if (this.outputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(this.outputS3BucketName()).append(",");
        }
        if (this.outputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(this.outputS3KeyPrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandPluginMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String statusDetails;
        private Integer responseCode;
        private Instant responseStartDateTime;
        private Instant responseFinishDateTime;
        private String output;
        private String standardOutputUrl;
        private String standardErrorUrl;
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandPlugin model) {
            this.setName(model.name);
            this.setStatus(model.status);
            this.setStatusDetails(model.statusDetails);
            this.setResponseCode(model.responseCode);
            this.setResponseStartDateTime(model.responseStartDateTime);
            this.setResponseFinishDateTime(model.responseFinishDateTime);
            this.setOutput(model.output);
            this.setStandardOutputUrl(model.standardOutputUrl);
            this.setStandardErrorUrl(model.standardErrorUrl);
            this.setOutputS3Region(model.outputS3Region);
            this.setOutputS3BucketName(model.outputS3BucketName);
            this.setOutputS3KeyPrefix(model.outputS3KeyPrefix);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandPluginStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Integer getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public final Instant getResponseStartDateTime() {
            return this.responseStartDateTime;
        }

        @Override
        public final Builder responseStartDateTime(Instant responseStartDateTime) {
            this.responseStartDateTime = responseStartDateTime;
            return this;
        }

        public final void setResponseStartDateTime(Instant responseStartDateTime) {
            this.responseStartDateTime = responseStartDateTime;
        }

        public final Instant getResponseFinishDateTime() {
            return this.responseFinishDateTime;
        }

        @Override
        public final Builder responseFinishDateTime(Instant responseFinishDateTime) {
            this.responseFinishDateTime = responseFinishDateTime;
            return this;
        }

        public final void setResponseFinishDateTime(Instant responseFinishDateTime) {
            this.responseFinishDateTime = responseFinishDateTime;
        }

        public final String getOutput() {
            return this.output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        public final String getStandardOutputUrl() {
            return this.standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorUrl() {
            return this.standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public CommandPlugin build() {
            return new CommandPlugin(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CommandPlugin> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(CommandPluginStatus var1);

        public Builder statusDetails(String var1);

        public Builder responseCode(Integer var1);

        public Builder responseStartDateTime(Instant var1);

        public Builder responseFinishDateTime(Instant var1);

        public Builder output(String var1);

        public Builder standardOutputUrl(String var1);

        public Builder standardErrorUrl(String var1);

        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);
    }
}

