/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.S3OutputUrl;

public class S3OutputUrlUnmarshaller
implements Unmarshaller<S3OutputUrl, JsonUnmarshallerContext> {
    private static S3OutputUrlUnmarshaller INSTANCE;

    public S3OutputUrl unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3OutputUrl.Builder s3OutputUrlBuilder = S3OutputUrl.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OutputUrl", targetDepth)) {
                    context.nextToken();
                    s3OutputUrlBuilder.outputUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3OutputUrl)s3OutputUrlBuilder.build();
    }

    public static S3OutputUrlUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new S3OutputUrlUnmarshaller();
        }
        return INSTANCE;
    }
}

