/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryResultItem;

@SdkInternalApi
public class InventoryResultItemMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").build();
    private static final MarshallingInfo<String> CAPTURETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaptureTime").build();
    private static final MarshallingInfo<String> CONTENTHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentHash").build();
    private static final MarshallingInfo<List> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").build();
    private static final InventoryResultItemMarshaller instance = new InventoryResultItemMarshaller();

    public static InventoryResultItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(InventoryResultItem inventoryResultItem, ProtocolMarshaller protocolMarshaller) {
        if (inventoryResultItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inventoryResultItem.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)inventoryResultItem.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)inventoryResultItem.captureTime(), CAPTURETIME_BINDING);
            protocolMarshaller.marshall((Object)inventoryResultItem.contentHash(), CONTENTHASH_BINDING);
            protocolMarshaller.marshall(inventoryResultItem.content(), CONTENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

