/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;

@SdkInternalApi
public class InstancePatchStateMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> PATCHGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PatchGroup").build();
    private static final MarshallingInfo<String> BASELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaselineId").build();
    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotId").build();
    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").build();
    private static final MarshallingInfo<Integer> INSTALLEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledCount").build();
    private static final MarshallingInfo<Integer> INSTALLEDOTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledOtherCount").build();
    private static final MarshallingInfo<Integer> MISSINGCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MissingCount").build();
    private static final MarshallingInfo<Integer> FAILEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailedCount").build();
    private static final MarshallingInfo<Integer> NOTAPPLICABLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotApplicableCount").build();
    private static final MarshallingInfo<Instant> OPERATIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperationStartTime").build();
    private static final MarshallingInfo<Instant> OPERATIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperationEndTime").build();
    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operation").build();
    private static final InstancePatchStateMarshaller instance = new InstancePatchStateMarshaller();

    public static InstancePatchStateMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstancePatchState instancePatchState, ProtocolMarshaller protocolMarshaller) {
        if (instancePatchState == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instancePatchState.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.patchGroup(), PATCHGROUP_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.baselineId(), BASELINEID_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.snapshotId(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.ownerInformation(), OWNERINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.installedCount(), INSTALLEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.installedOtherCount(), INSTALLEDOTHERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.missingCount(), MISSINGCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.failedCount(), FAILEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.notApplicableCount(), NOTAPPLICABLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.operationStartTime(), OPERATIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.operationEndTime(), OPERATIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.operation(), OPERATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

