/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;

@SdkInternalApi
public class GetParametersByPathRequestModelMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").build();
    private static final MarshallingInfo<Boolean> RECURSIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Recursive").build();
    private static final MarshallingInfo<List> PARAMETERFILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterFilters").build();
    private static final MarshallingInfo<Boolean> WITHDECRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WithDecryption").build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").build();
    private static final GetParametersByPathRequestModelMarshaller instance = new GetParametersByPathRequestModelMarshaller();

    public static GetParametersByPathRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(GetParametersByPathRequest getParametersByPathRequest, ProtocolMarshaller protocolMarshaller) {
        if (getParametersByPathRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)getParametersByPathRequest.path(), PATH_BINDING);
            protocolMarshaller.marshall((Object)getParametersByPathRequest.recursive(), RECURSIVE_BINDING);
            protocolMarshaller.marshall(getParametersByPathRequest.parameterFilters(), PARAMETERFILTERS_BINDING);
            protocolMarshaller.marshall((Object)getParametersByPathRequest.withDecryption(), WITHDECRYPTION_BINDING);
            protocolMarshaller.marshall((Object)getParametersByPathRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)getParametersByPathRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

