/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.util.IdempotentUtils;

@SdkInternalApi
public class CreatePatchBaselineRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> GLOBALFILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalFilters").build();
    private static final MarshallingInfo<StructuredPojo> APPROVALRULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovalRules").build();
    private static final MarshallingInfo<List> APPROVEDPATCHES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovedPatches").build();
    private static final MarshallingInfo<List> REJECTEDPATCHES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RejectedPatches").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final CreatePatchBaselineRequestModelMarshaller instance = new CreatePatchBaselineRequestModelMarshaller();

    public static CreatePatchBaselineRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreatePatchBaselineRequest createPatchBaselineRequest, ProtocolMarshaller protocolMarshaller) {
        if (createPatchBaselineRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createPatchBaselineRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createPatchBaselineRequest.globalFilters(), GLOBALFILTERS_BINDING);
            protocolMarshaller.marshall((Object)createPatchBaselineRequest.approvalRules(), APPROVALRULES_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.approvedPatches(), APPROVEDPATCHES_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.rejectedPatches(), REJECTEDPATCHES_BINDING);
            protocolMarshaller.marshall((Object)createPatchBaselineRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createPatchBaselineRequest.clientToken(), CLIENTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

