/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.DocumentFilter;
import software.amazon.awssdk.services.ssm.model.DocumentFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDocumentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListDocumentsRequest> {
    private final List<DocumentFilter> documentFilterList;
    private final Integer maxResults;
    private final String nextToken;

    private ListDocumentsRequest(BuilderImpl builder) {
        this.documentFilterList = builder.documentFilterList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<DocumentFilter> documentFilterList() {
        return this.documentFilterList;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.documentFilterList() == null ? 0 : this.documentFilterList().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsRequest)) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest)((Object)obj);
        if (other.documentFilterList() == null ^ this.documentFilterList() == null) {
            return false;
        }
        if (other.documentFilterList() != null && !other.documentFilterList().equals(this.documentFilterList())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.documentFilterList() != null) {
            sb.append("DocumentFilterList: ").append(this.documentFilterList()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DocumentFilter> documentFilterList;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsRequest model) {
            this.setDocumentFilterList(model.documentFilterList);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<DocumentFilter> getDocumentFilterList() {
            return this.documentFilterList;
        }

        @Override
        public final Builder documentFilterList(Collection<DocumentFilter> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copy(documentFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(DocumentFilter ... documentFilterList) {
            this.documentFilterList(Arrays.asList(documentFilterList));
            return this;
        }

        public final void setDocumentFilterList(Collection<DocumentFilter> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copy(documentFilterList);
        }

        @SafeVarargs
        public final void setDocumentFilterList(DocumentFilter ... documentFilterList) {
            this.documentFilterList(Arrays.asList(documentFilterList));
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDocumentsRequest build() {
            return new ListDocumentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDocumentsRequest> {
        public Builder documentFilterList(Collection<DocumentFilter> var1);

        public Builder documentFilterList(DocumentFilter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

