/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.model.PatchGroupListCopier;
import software.amazon.awssdk.services.ssm.model.PatchIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPatchBaselineResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetPatchBaselineResponse> {
    private final String baselineId;
    private final String name;
    private final PatchFilterGroup globalFilters;
    private final PatchRuleGroup approvalRules;
    private final List<String> approvedPatches;
    private final List<String> rejectedPatches;
    private final List<String> patchGroups;
    private final Instant createdDate;
    private final Instant modifiedDate;
    private final String description;

    private GetPatchBaselineResponse(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.rejectedPatches = builder.rejectedPatches;
        this.patchGroups = builder.patchGroups;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.description = builder.description;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String name() {
        return this.name;
    }

    public PatchFilterGroup globalFilters() {
        return this.globalFilters;
    }

    public PatchRuleGroup approvalRules() {
        return this.approvalRules;
    }

    public List<String> approvedPatches() {
        return this.approvedPatches;
    }

    public List<String> rejectedPatches() {
        return this.rejectedPatches;
    }

    public List<String> patchGroups() {
        return this.patchGroups;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant modifiedDate() {
        return this.modifiedDate;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.baselineId() == null ? 0 : this.baselineId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.globalFilters() == null ? 0 : this.globalFilters().hashCode());
        hashCode = 31 * hashCode + (this.approvalRules() == null ? 0 : this.approvalRules().hashCode());
        hashCode = 31 * hashCode + (this.approvedPatches() == null ? 0 : this.approvedPatches().hashCode());
        hashCode = 31 * hashCode + (this.rejectedPatches() == null ? 0 : this.rejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.patchGroups() == null ? 0 : this.patchGroups().hashCode());
        hashCode = 31 * hashCode + (this.createdDate() == null ? 0 : this.createdDate().hashCode());
        hashCode = 31 * hashCode + (this.modifiedDate() == null ? 0 : this.modifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineResponse)) {
            return false;
        }
        GetPatchBaselineResponse other = (GetPatchBaselineResponse)((Object)obj);
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.globalFilters() == null ^ this.globalFilters() == null) {
            return false;
        }
        if (other.globalFilters() != null && !other.globalFilters().equals(this.globalFilters())) {
            return false;
        }
        if (other.approvalRules() == null ^ this.approvalRules() == null) {
            return false;
        }
        if (other.approvalRules() != null && !other.approvalRules().equals(this.approvalRules())) {
            return false;
        }
        if (other.approvedPatches() == null ^ this.approvedPatches() == null) {
            return false;
        }
        if (other.approvedPatches() != null && !other.approvedPatches().equals(this.approvedPatches())) {
            return false;
        }
        if (other.rejectedPatches() == null ^ this.rejectedPatches() == null) {
            return false;
        }
        if (other.rejectedPatches() != null && !other.rejectedPatches().equals(this.rejectedPatches())) {
            return false;
        }
        if (other.patchGroups() == null ^ this.patchGroups() == null) {
            return false;
        }
        if (other.patchGroups() != null && !other.patchGroups().equals(this.patchGroups())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.modifiedDate() == null ^ this.modifiedDate() == null) {
            return false;
        }
        if (other.modifiedDate() != null && !other.modifiedDate().equals(this.modifiedDate())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baselineId() != null) {
            sb.append("BaselineId: ").append(this.baselineId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.globalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.globalFilters()).append(",");
        }
        if (this.approvalRules() != null) {
            sb.append("ApprovalRules: ").append(this.approvalRules()).append(",");
        }
        if (this.approvedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.approvedPatches()).append(",");
        }
        if (this.rejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.rejectedPatches()).append(",");
        }
        if (this.patchGroups() != null) {
            sb.append("PatchGroups: ").append(this.patchGroups()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (this.modifiedDate() != null) {
            sb.append("ModifiedDate: ").append(this.modifiedDate()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String baselineId;
        private String name;
        private PatchFilterGroup globalFilters;
        private PatchRuleGroup approvalRules;
        private List<String> approvedPatches;
        private List<String> rejectedPatches;
        private List<String> patchGroups;
        private Instant createdDate;
        private Instant modifiedDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineResponse model) {
            this.setBaselineId(model.baselineId);
            this.setName(model.name);
            this.setGlobalFilters(model.globalFilters);
            this.setApprovalRules(model.approvalRules);
            this.setApprovedPatches(model.approvedPatches);
            this.setRejectedPatches(model.rejectedPatches);
            this.setPatchGroups(model.patchGroups);
            this.setCreatedDate(model.createdDate);
            this.setModifiedDate(model.modifiedDate);
            this.setDescription(model.description);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PatchFilterGroup getGlobalFilters() {
            return this.globalFilters;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
        }

        public final PatchRuleGroup getApprovalRules() {
            return this.approvalRules;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
        }

        public final Collection<String> getApprovedPatches() {
            return this.approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        @SafeVarargs
        public final void setApprovedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
        }

        public final Collection<String> getRejectedPatches() {
            return this.rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        @SafeVarargs
        public final void setRejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
        }

        public final Collection<String> getPatchGroups() {
            return this.patchGroups;
        }

        @Override
        public final Builder patchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchGroups(String ... patchGroups) {
            this.patchGroups(Arrays.asList(patchGroups));
            return this;
        }

        public final void setPatchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
        }

        @SafeVarargs
        public final void setPatchGroups(String ... patchGroups) {
            this.patchGroups(Arrays.asList(patchGroups));
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return this.modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public GetPatchBaselineResponse build() {
            return new GetPatchBaselineResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetPatchBaselineResponse> {
        public Builder baselineId(String var1);

        public Builder name(String var1);

        public Builder globalFilters(PatchFilterGroup var1);

        public Builder approvalRules(PatchRuleGroup var1);

        public Builder approvedPatches(Collection<String> var1);

        public Builder approvedPatches(String ... var1);

        public Builder rejectedPatches(Collection<String> var1);

        public Builder rejectedPatches(String ... var1);

        public Builder patchGroups(Collection<String> var1);

        public Builder patchGroups(String ... var1);

        public Builder createdDate(Instant var1);

        public Builder modifiedDate(Instant var1);

        public Builder description(String var1);
    }
}

