/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.PatchComplianceData;
import software.amazon.awssdk.services.ssm.model.PatchComplianceDataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancePatchesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstancePatchesResponse> {
    private final List<PatchComplianceData> patches;
    private final String nextToken;

    private DescribeInstancePatchesResponse(BuilderImpl builder) {
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    public List<PatchComplianceData> patches() {
        return this.patches;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.patches() == null ? 0 : this.patches().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesResponse)) {
            return false;
        }
        DescribeInstancePatchesResponse other = (DescribeInstancePatchesResponse)((Object)obj);
        if (other.patches() == null ^ this.patches() == null) {
            return false;
        }
        if (other.patches() != null && !other.patches().equals(this.patches())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.patches() != null) {
            sb.append("Patches: ").append(this.patches()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PatchComplianceData> patches;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesResponse model) {
            this.setPatches(model.patches);
            this.setNextToken(model.nextToken);
        }

        public final Collection<PatchComplianceData> getPatches() {
            return this.patches;
        }

        @Override
        public final Builder patches(Collection<PatchComplianceData> patches) {
            this.patches = PatchComplianceDataListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(PatchComplianceData ... patches) {
            this.patches(Arrays.asList(patches));
            return this;
        }

        public final void setPatches(Collection<PatchComplianceData> patches) {
            this.patches = PatchComplianceDataListCopier.copy(patches);
        }

        @SafeVarargs
        public final void setPatches(PatchComplianceData ... patches) {
            this.patches(Arrays.asList(patches));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstancePatchesResponse build() {
            return new DescribeInstancePatchesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancePatchesResponse> {
        public Builder patches(Collection<PatchComplianceData> var1);

        public Builder patches(PatchComplianceData ... var1);

        public Builder nextToken(String var1);
    }
}

