/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;
import software.amazon.awssdk.services.ssm.model.InstancePatchStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancePatchStatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstancePatchStatesResponse> {
    private final List<InstancePatchState> instancePatchStates;
    private final String nextToken;

    private DescribeInstancePatchStatesResponse(BuilderImpl builder) {
        this.instancePatchStates = builder.instancePatchStates;
        this.nextToken = builder.nextToken;
    }

    public List<InstancePatchState> instancePatchStates() {
        return this.instancePatchStates;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instancePatchStates() == null ? 0 : this.instancePatchStates().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesResponse)) {
            return false;
        }
        DescribeInstancePatchStatesResponse other = (DescribeInstancePatchStatesResponse)((Object)obj);
        if (other.instancePatchStates() == null ^ this.instancePatchStates() == null) {
            return false;
        }
        if (other.instancePatchStates() != null && !other.instancePatchStates().equals(this.instancePatchStates())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instancePatchStates() != null) {
            sb.append("InstancePatchStates: ").append(this.instancePatchStates()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstancePatchState> instancePatchStates;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesResponse model) {
            this.setInstancePatchStates(model.instancePatchStates);
            this.setNextToken(model.nextToken);
        }

        public final Collection<InstancePatchState> getInstancePatchStates() {
            return this.instancePatchStates;
        }

        @Override
        public final Builder instancePatchStates(Collection<InstancePatchState> instancePatchStates) {
            this.instancePatchStates = InstancePatchStateListCopier.copy(instancePatchStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePatchStates(InstancePatchState ... instancePatchStates) {
            this.instancePatchStates(Arrays.asList(instancePatchStates));
            return this;
        }

        public final void setInstancePatchStates(Collection<InstancePatchState> instancePatchStates) {
            this.instancePatchStates = InstancePatchStateListCopier.copy(instancePatchStates);
        }

        @SafeVarargs
        public final void setInstancePatchStates(InstancePatchState ... instancePatchStates) {
            this.instancePatchStates(Arrays.asList(instancePatchStates));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstancePatchStatesResponse build() {
            return new DescribeInstancePatchStatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancePatchStatesResponse> {
        public Builder instancePatchStates(Collection<InstancePatchState> var1);

        public Builder instancePatchStates(InstancePatchState ... var1);

        public Builder nextToken(String var1);
    }
}

