/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter;
import software.amazon.awssdk.services.ssm.model.InstancePatchStateFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancePatchStatesForPatchGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
    private final String patchGroup;
    private final List<InstancePatchStateFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeInstancePatchStatesForPatchGroupRequest(BuilderImpl builder) {
        this.patchGroup = builder.patchGroup;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String patchGroup() {
        return this.patchGroup;
    }

    public List<InstancePatchStateFilter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.patchGroup() == null ? 0 : this.patchGroup().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesForPatchGroupRequest)) {
            return false;
        }
        DescribeInstancePatchStatesForPatchGroupRequest other = (DescribeInstancePatchStatesForPatchGroupRequest)((Object)obj);
        if (other.patchGroup() == null ^ this.patchGroup() == null) {
            return false;
        }
        if (other.patchGroup() != null && !other.patchGroup().equals(this.patchGroup())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.patchGroup() != null) {
            sb.append("PatchGroup: ").append(this.patchGroup()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String patchGroup;
        private List<InstancePatchStateFilter> filters;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesForPatchGroupRequest model) {
            this.setPatchGroup(model.patchGroup);
            this.setFilters(model.filters);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
        }

        public final String getPatchGroup() {
            return this.patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final Collection<InstancePatchStateFilter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<InstancePatchStateFilter> filters) {
            this.filters = InstancePatchStateFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InstancePatchStateFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<InstancePatchStateFilter> filters) {
            this.filters = InstancePatchStateFilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(InstancePatchStateFilter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public DescribeInstancePatchStatesForPatchGroupRequest build() {
            return new DescribeInstancePatchStatesForPatchGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
        public Builder patchGroup(String var1);

        public Builder filters(Collection<InstancePatchStateFilter> var1);

        public Builder filters(InstancePatchStateFilter ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

